/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContinuousExportsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeContinuousExportsResponse.Builder, DescribeContinuousExportsResponse> {
    private static final SdkField<List<ContinuousExportDescription>> DESCRIPTIONS_FIELD = SdkField
            .<List<ContinuousExportDescription>> builder(MarshallingType.LIST)
            .memberName("descriptions")
            .getter(getter(DescribeContinuousExportsResponse::descriptions))
            .setter(setter(Builder::descriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContinuousExportDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContinuousExportDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeContinuousExportsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ContinuousExportDescription> descriptions;

    private final String nextToken;

    private DescribeContinuousExportsResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Descriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDescriptions() {
        return descriptions != null && !(descriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of continuous export descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDescriptions} method.
     * </p>
     * 
     * @return A list of continuous export descriptions.
     */
    public final List<ContinuousExportDescription> descriptions() {
        return descriptions;
    }

    /**
     * <p>
     * The token from the previous call to <code>DescribeExportTasks</code>.
     * </p>
     * 
     * @return The token from the previous call to <code>DescribeExportTasks</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDescriptions() ? descriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContinuousExportsResponse)) {
            return false;
        }
        DescribeContinuousExportsResponse other = (DescribeContinuousExportsResponse) obj;
        return hasDescriptions() == other.hasDescriptions() && Objects.equals(descriptions(), other.descriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContinuousExportsResponse")
                .add("Descriptions", hasDescriptions() ? descriptions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "descriptions":
            return Optional.ofNullable(clazz.cast(descriptions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("descriptions", DESCRIPTIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContinuousExportsResponse, T> g) {
        return obj -> g.apply((DescribeContinuousExportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeContinuousExportsResponse> {
        /**
         * <p>
         * A list of continuous export descriptions.
         * </p>
         * 
         * @param descriptions
         *        A list of continuous export descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(Collection<ContinuousExportDescription> descriptions);

        /**
         * <p>
         * A list of continuous export descriptions.
         * </p>
         * 
         * @param descriptions
         *        A list of continuous export descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(ContinuousExportDescription... descriptions);

        /**
         * <p>
         * A list of continuous export descriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription.Builder#build()}
         * is called immediately and its result is passed to {@link #descriptions(List<ContinuousExportDescription>)}.
         * 
         * @param descriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #descriptions(java.util.Collection<ContinuousExportDescription>)
         */
        Builder descriptions(Consumer<ContinuousExportDescription.Builder>... descriptions);

        /**
         * <p>
         * The token from the previous call to <code>DescribeExportTasks</code>.
         * </p>
         * 
         * @param nextToken
         *        The token from the previous call to <code>DescribeExportTasks</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<ContinuousExportDescription> descriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContinuousExportsResponse model) {
            super(model);
            descriptions(model.descriptions);
            nextToken(model.nextToken);
        }

        public final List<ContinuousExportDescription.Builder> getDescriptions() {
            List<ContinuousExportDescription.Builder> result = ContinuousExportDescriptionsCopier
                    .copyToBuilder(this.descriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescriptions(Collection<ContinuousExportDescription.BuilderImpl> descriptions) {
            this.descriptions = ContinuousExportDescriptionsCopier.copyFromBuilder(descriptions);
        }

        @Override
        public final Builder descriptions(Collection<ContinuousExportDescription> descriptions) {
            this.descriptions = ContinuousExportDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(ContinuousExportDescription... descriptions) {
            descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<ContinuousExportDescription.Builder>... descriptions) {
            descriptions(Stream.of(descriptions).map(c -> ContinuousExportDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeContinuousExportsResponse build() {
            return new DescribeContinuousExportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
