/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExportTasksResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeExportTasksResponse.Builder, DescribeExportTasksResponse> {
    private static final SdkField<List<ExportInfo>> EXPORTS_INFO_FIELD = SdkField
            .<List<ExportInfo>> builder(MarshallingType.LIST)
            .memberName("exportsInfo")
            .getter(getter(DescribeExportTasksResponse::exportsInfo))
            .setter(setter(Builder::exportsInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportsInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeExportTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORTS_INFO_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ExportInfo> exportsInfo;

    private final String nextToken;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.exportsInfo = builder.exportsInfo;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportsInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportsInfo() {
        return exportsInfo != null && !(exportsInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>, the
     * response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportsInfo} method.
     * </p>
     * 
     * @return Contains one or more sets of export request details. When the status of a request is
     *         <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can view the data
     *         in a CSV file.
     */
    public final List<ExportInfo> exportsInfo() {
        return exportsInfo;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When the
     * results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is null when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When
     *         the results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can
     *         be used to retrieve the next page of results. This value is null when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportsInfo() ? exportsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse) obj;
        return hasExportsInfo() == other.hasExportsInfo() && Objects.equals(exportsInfo(), other.exportsInfo())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExportTasksResponse").add("ExportsInfo", hasExportsInfo() ? exportsInfo() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportsInfo":
            return Optional.ofNullable(clazz.cast(exportsInfo()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportsInfo", EXPORTS_INFO_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExportTasksResponse, T> g) {
        return obj -> g.apply((DescribeExportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeExportTasksResponse> {
        /**
         * <p>
         * Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>,
         * the response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.
         * </p>
         * 
         * @param exportsInfo
         *        Contains one or more sets of export request details. When the status of a request is
         *        <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can view the
         *        data in a CSV file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportsInfo(Collection<ExportInfo> exportsInfo);

        /**
         * <p>
         * Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>,
         * the response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.
         * </p>
         * 
         * @param exportsInfo
         *        Contains one or more sets of export request details. When the status of a request is
         *        <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can view the
         *        data in a CSV file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportsInfo(ExportInfo... exportsInfo);

        /**
         * <p>
         * Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>,
         * the response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #exportsInfo(List<ExportInfo>)}.
         * 
         * @param exportsInfo
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportsInfo(java.util.Collection<ExportInfo>)
         */
        Builder exportsInfo(Consumer<ExportInfo.Builder>... exportsInfo);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When the
         * results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be used
         * to retrieve the next page of results. This value is null when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When
         *        the results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is null when there are no more results to
         *        return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<ExportInfo> exportsInfo = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            super(model);
            exportsInfo(model.exportsInfo);
            nextToken(model.nextToken);
        }

        public final List<ExportInfo.Builder> getExportsInfo() {
            List<ExportInfo.Builder> result = ExportsInfoCopier.copyToBuilder(this.exportsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExportsInfo(Collection<ExportInfo.BuilderImpl> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copyFromBuilder(exportsInfo);
        }

        @Override
        public final Builder exportsInfo(Collection<ExportInfo> exportsInfo) {
            this.exportsInfo = ExportsInfoCopier.copy(exportsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(ExportInfo... exportsInfo) {
            exportsInfo(Arrays.asList(exportsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportsInfo(Consumer<ExportInfo.Builder>... exportsInfo) {
            exportsInfo(Stream.of(exportsInfo).map(c -> ExportInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
