/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the type of data that is being exported. Only one <code>ExportPreferences</code> can be enabled for a <a
 * href
 * ="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html">StartExportTask</a>
 * action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportPreferences.Builder, ExportPreferences> {
    private static final SdkField<Ec2RecommendationsExportPreferences> EC2_RECOMMENDATIONS_PREFERENCES_FIELD = SdkField
            .<Ec2RecommendationsExportPreferences> builder(MarshallingType.SDK_POJO)
            .memberName("ec2RecommendationsPreferences")
            .getter(getter(ExportPreferences::ec2RecommendationsPreferences))
            .setter(setter(Builder::ec2RecommendationsPreferences))
            .constructor(Ec2RecommendationsExportPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2RecommendationsPreferences")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EC2_RECOMMENDATIONS_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Ec2RecommendationsExportPreferences ec2RecommendationsPreferences;

    private final Type type;

    private ExportPreferences(BuilderImpl builder) {
        this.ec2RecommendationsPreferences = builder.ec2RecommendationsPreferences;
        this.type = builder.type;
    }

    /**
     * <p>
     * If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through Amazon
     * Web Services Application Discovery Service.
     * </p>
     * 
     * @return If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through
     *         Amazon Web Services Application Discovery Service.
     */
    public final Ec2RecommendationsExportPreferences ec2RecommendationsPreferences() {
        return ec2RecommendationsPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2RecommendationsPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportPreferences)) {
            return false;
        }
        ExportPreferences other = (ExportPreferences) obj;
        return Objects.equals(ec2RecommendationsPreferences(), other.ec2RecommendationsPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportPreferences").add("Ec2RecommendationsPreferences", ec2RecommendationsPreferences())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2RecommendationsPreferences":
            return Optional.ofNullable(clazz.cast(ec2RecommendationsPreferences()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #ec2RecommendationsPreferences()} initialized to the given value.
     *
     * <p>
     * If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through Amazon
     * Web Services Application Discovery Service.
     * </p>
     * 
     * @param ec2RecommendationsPreferences
     *        If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through
     *        Amazon Web Services Application Discovery Service.
     */
    public static ExportPreferences fromEc2RecommendationsPreferences(
            Ec2RecommendationsExportPreferences ec2RecommendationsPreferences) {
        return builder().ec2RecommendationsPreferences(ec2RecommendationsPreferences).build();
    }

    /**
     * Create an instance of this class with {@link #ec2RecommendationsPreferences()} initialized to the given value.
     *
     * <p>
     * If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through Amazon
     * Web Services Application Discovery Service.
     * </p>
     * 
     * @param ec2RecommendationsPreferences
     *        If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through
     *        Amazon Web Services Application Discovery Service.
     */
    public static ExportPreferences fromEc2RecommendationsPreferences(
            Consumer<Ec2RecommendationsExportPreferences.Builder> ec2RecommendationsPreferences) {
        Ec2RecommendationsExportPreferences.Builder builder = Ec2RecommendationsExportPreferences.builder();
        ec2RecommendationsPreferences.accept(builder);
        return fromEc2RecommendationsPreferences(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ec2RecommendationsPreferences", EC2_RECOMMENDATIONS_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportPreferences, T> g) {
        return obj -> g.apply((ExportPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportPreferences> {
        /**
         * <p>
         * If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through
         * Amazon Web Services Application Discovery Service.
         * </p>
         * 
         * @param ec2RecommendationsPreferences
         *        If enabled, exported data includes EC2 instance type matches for on-premises servers discovered
         *        through Amazon Web Services Application Discovery Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2RecommendationsPreferences(Ec2RecommendationsExportPreferences ec2RecommendationsPreferences);

        /**
         * <p>
         * If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through
         * Amazon Web Services Application Discovery Service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link Ec2RecommendationsExportPreferences.Builder} avoiding the need to create one manually via
         * {@link Ec2RecommendationsExportPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2RecommendationsExportPreferences.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ec2RecommendationsPreferences(Ec2RecommendationsExportPreferences)}.
         * 
         * @param ec2RecommendationsPreferences
         *        a consumer that will call methods on {@link Ec2RecommendationsExportPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2RecommendationsPreferences(Ec2RecommendationsExportPreferences)
         */
        default Builder ec2RecommendationsPreferences(
                Consumer<Ec2RecommendationsExportPreferences.Builder> ec2RecommendationsPreferences) {
            return ec2RecommendationsPreferences(Ec2RecommendationsExportPreferences.builder()
                    .applyMutation(ec2RecommendationsPreferences).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Ec2RecommendationsExportPreferences ec2RecommendationsPreferences;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportPreferences model) {
            ec2RecommendationsPreferences(model.ec2RecommendationsPreferences);
        }

        public final Ec2RecommendationsExportPreferences.Builder getEc2RecommendationsPreferences() {
            return ec2RecommendationsPreferences != null ? ec2RecommendationsPreferences.toBuilder() : null;
        }

        public final void setEc2RecommendationsPreferences(
                Ec2RecommendationsExportPreferences.BuilderImpl ec2RecommendationsPreferences) {
            Object oldValue = this.ec2RecommendationsPreferences;
            this.ec2RecommendationsPreferences = ec2RecommendationsPreferences != null ? ec2RecommendationsPreferences.build()
                    : null;
            handleUnionValueChange(Type.EC2_RECOMMENDATIONS_PREFERENCES, oldValue, this.ec2RecommendationsPreferences);
        }

        @Override
        public final Builder ec2RecommendationsPreferences(Ec2RecommendationsExportPreferences ec2RecommendationsPreferences) {
            Object oldValue = this.ec2RecommendationsPreferences;
            this.ec2RecommendationsPreferences = ec2RecommendationsPreferences;
            handleUnionValueChange(Type.EC2_RECOMMENDATIONS_PREFERENCES, oldValue, this.ec2RecommendationsPreferences);
            return this;
        }

        @Override
        public ExportPreferences build() {
            return new ExportPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExportPreferences#type()
     */
    public enum Type {
        EC2_RECOMMENDATIONS_PREFERENCES,

        UNKNOWN_TO_SDK_VERSION
    }
}
