/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration ID paired with an error message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FailedConfiguration.Builder, FailedConfiguration> {
    private static final SdkField<String> CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configurationId").getter(getter(FailedConfiguration::configurationId))
            .setter(setter(Builder::configurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationId").build()).build();

    private static final SdkField<Integer> ERROR_STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("errorStatusCode").getter(getter(FailedConfiguration::errorStatusCode))
            .setter(setter(Builder::errorStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorStatusCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(FailedConfiguration::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_ID_FIELD,
            ERROR_STATUS_CODE_FIELD, ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationId;

    private final Integer errorStatusCode;

    private final String errorMessage;

    private FailedConfiguration(BuilderImpl builder) {
        this.configurationId = builder.configurationId;
        this.errorStatusCode = builder.errorStatusCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The unique identifier of the configuration the failed to delete.
     * </p>
     * 
     * @return The unique identifier of the configuration the failed to delete.
     */
    public final String configurationId() {
        return configurationId;
    }

    /**
     * <p>
     * The integer error code associated with the error message.
     * </p>
     * 
     * @return The integer error code associated with the error message.
     */
    public final Integer errorStatusCode() {
        return errorStatusCode;
    }

    /**
     * <p>
     * A descriptive message indicating why the associated configuration failed to delete.
     * </p>
     * 
     * @return A descriptive message indicating why the associated configuration failed to delete.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationId());
        hashCode = 31 * hashCode + Objects.hashCode(errorStatusCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedConfiguration)) {
            return false;
        }
        FailedConfiguration other = (FailedConfiguration) obj;
        return Objects.equals(configurationId(), other.configurationId())
                && Objects.equals(errorStatusCode(), other.errorStatusCode())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailedConfiguration").add("ConfigurationId", configurationId())
                .add("ErrorStatusCode", errorStatusCode()).add("ErrorMessage", errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurationId":
            return Optional.ofNullable(clazz.cast(configurationId()));
        case "errorStatusCode":
            return Optional.ofNullable(clazz.cast(errorStatusCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configurationId", CONFIGURATION_ID_FIELD);
        map.put("errorStatusCode", ERROR_STATUS_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailedConfiguration, T> g) {
        return obj -> g.apply((FailedConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailedConfiguration> {
        /**
         * <p>
         * The unique identifier of the configuration the failed to delete.
         * </p>
         * 
         * @param configurationId
         *        The unique identifier of the configuration the failed to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationId(String configurationId);

        /**
         * <p>
         * The integer error code associated with the error message.
         * </p>
         * 
         * @param errorStatusCode
         *        The integer error code associated with the error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorStatusCode(Integer errorStatusCode);

        /**
         * <p>
         * A descriptive message indicating why the associated configuration failed to delete.
         * </p>
         * 
         * @param errorMessage
         *        A descriptive message indicating why the associated configuration failed to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String configurationId;

        private Integer errorStatusCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedConfiguration model) {
            configurationId(model.configurationId);
            errorStatusCode(model.errorStatusCode);
            errorMessage(model.errorMessage);
        }

        public final String getConfigurationId() {
            return configurationId;
        }

        public final void setConfigurationId(String configurationId) {
            this.configurationId = configurationId;
        }

        @Override
        public final Builder configurationId(String configurationId) {
            this.configurationId = configurationId;
            return this;
        }

        public final Integer getErrorStatusCode() {
            return errorStatusCode;
        }

        public final void setErrorStatusCode(Integer errorStatusCode) {
            this.errorStatusCode = errorStatusCode;
        }

        @Override
        public final Builder errorStatusCode(Integer errorStatusCode) {
            this.errorStatusCode = errorStatusCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public FailedConfiguration build() {
            return new FailedConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
