/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<StartExportTaskRequest.Builder, StartExportTaskRequest> {
    private static final SdkField<List<String>> EXPORT_DATA_FORMAT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportDataFormat")
            .getter(getter(StartExportTaskRequest::exportDataFormatAsStrings))
            .setter(setter(Builder::exportDataFormatWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataFormat").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ExportFilter>> FILTERS_FIELD = SdkField
            .<List<ExportFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(StartExportTaskRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ExportFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(StartExportTaskRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(StartExportTaskRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<ExportPreferences> PREFERENCES_FIELD = SdkField
            .<ExportPreferences> builder(MarshallingType.SDK_POJO).memberName("preferences")
            .getter(getter(StartExportTaskRequest::preferences)).setter(setter(Builder::preferences))
            .constructor(ExportPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preferences").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_FORMAT_FIELD,
            FILTERS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> exportDataFormat;

    private final List<ExportFilter> filters;

    private final Instant startTime;

    private final Instant endTime;

    private final ExportPreferences preferences;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataFormat = builder.exportDataFormat;
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.preferences = builder.preferences;
    }

    /**
     * <p>
     * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     * <code>GRAPHML</code> <i>option has been deprecated.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportDataFormat} method.
     * </p>
     * 
     * @return The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     *         <code>GRAPHML</code> <i>option has been deprecated.</i>
     */
    public final List<ExportDataFormat> exportDataFormat() {
        return ExportDataFormatsCopier.copyStringToEnum(exportDataFormat);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportDataFormat property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportDataFormat() {
        return exportDataFormat != null && !(exportDataFormat instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     * <code>GRAPHML</code> <i>option has been deprecated.</i>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportDataFormat} method.
     * </p>
     * 
     * @return The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
     *         <code>GRAPHML</code> <i>option has been deprecated.</i>
     */
    public final List<String> exportDataFormatAsStrings() {
        return exportDataFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which
     * data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or
     * CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data
     * includes both Amazon Web Services Application Discovery Service Agentless Collector collectors data and summary
     * data from Application Discovery Agent agents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
     *         which data is exported. The <code>agentId</code> can be found in the results of the
     *         <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
     *         <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application
     *         Discovery Service Agentless Collector collectors data and summary data from Application Discovery Agent
     *         agents.
     */
    public final List<ExportFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no
     * value is specified, data is exported starting from the first data collected by the agent.
     * </p>
     * 
     * @return The start timestamp for exported data from the single Application Discovery Agent selected in the
     *         filters. If no value is specified, data is exported starting from the first data collected by the agent.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no
     * value is specified, exported data includes the most recent data collected by the agent.
     * </p>
     * 
     * @return The end timestamp for exported data from the single Application Discovery Agent selected in the filters.
     *         If no value is specified, exported data includes the most recent data collected by the agent.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Indicates the type of data that needs to be exported. Only one <a
     * href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html"
     * >ExportPreferences</a> can be enabled at any time.
     * </p>
     * 
     * @return Indicates the type of data that needs to be exported. Only one <a
     *         href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html"
     *         >ExportPreferences</a> can be enabled at any time.
     */
    public final ExportPreferences preferences() {
        return preferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExportDataFormat() ? exportDataFormatAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(preferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest) obj;
        return hasExportDataFormat() == other.hasExportDataFormat()
                && Objects.equals(exportDataFormatAsStrings(), other.exportDataFormatAsStrings())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(preferences(), other.preferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportTaskRequest")
                .add("ExportDataFormat", hasExportDataFormat() ? exportDataFormatAsStrings() : null)
                .add("Filters", hasFilters() ? filters() : null).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Preferences", preferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportDataFormat":
            return Optional.ofNullable(clazz.cast(exportDataFormatAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "preferences":
            return Optional.ofNullable(clazz.cast(preferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportDataFormat", EXPORT_DATA_FORMAT_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("preferences", PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartExportTaskRequest> {
        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormatWithStrings(Collection<String> exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormatWithStrings(String... exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat);

        /**
         * <p>
         * The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i>
         * <code>GRAPHML</code> <i>option has been deprecated.</i>
         * </p>
         * 
         * @param exportDataFormat
         *        The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b>
         *        <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataFormat(ExportDataFormat... exportDataFormat);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application Discovery
         * Service Agentless Collector collectors data and summary data from Application Discovery Agent agents.
         * </p>
         * 
         * @param filters
         *        If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent
         *        for which data is exported. The <code>agentId</code> can be found in the results of the
         *        <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         *        <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application
         *        Discovery Service Agentless Collector collectors data and summary data from Application Discovery
         *        Agent agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ExportFilter> filters);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application Discovery
         * Service Agentless Collector collectors data and summary data from Application Discovery Agent agents.
         * </p>
         * 
         * @param filters
         *        If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent
         *        for which data is exported. The <code>agentId</code> can be found in the results of the
         *        <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         *        <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application
         *        Discovery Service Agentless Collector collectors data and summary data from Application Discovery
         *        Agent agents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ExportFilter... filters);

        /**
         * <p>
         * If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for
         * which data is exported. The <code>agentId</code> can be found in the results of the
         * <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and
         * <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application Discovery
         * Service Agentless Collector collectors data and summary data from Application Discovery Agent agents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ExportFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<ExportFilter>)
         */
        Builder filters(Consumer<ExportFilter.Builder>... filters);

        /**
         * <p>
         * The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If
         * no value is specified, data is exported starting from the first data collected by the agent.
         * </p>
         * 
         * @param startTime
         *        The start timestamp for exported data from the single Application Discovery Agent selected in the
         *        filters. If no value is specified, data is exported starting from the first data collected by the
         *        agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If
         * no value is specified, exported data includes the most recent data collected by the agent.
         * </p>
         * 
         * @param endTime
         *        The end timestamp for exported data from the single Application Discovery Agent selected in the
         *        filters. If no value is specified, exported data includes the most recent data collected by the agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Indicates the type of data that needs to be exported. Only one <a
         * href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html"
         * >ExportPreferences</a> can be enabled at any time.
         * </p>
         * 
         * @param preferences
         *        Indicates the type of data that needs to be exported. Only one <a href=
         *        "https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html"
         *        >ExportPreferences</a> can be enabled at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferences(ExportPreferences preferences);

        /**
         * <p>
         * Indicates the type of data that needs to be exported. Only one <a
         * href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html"
         * >ExportPreferences</a> can be enabled at any time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportPreferences.Builder} avoiding the
         * need to create one manually via {@link ExportPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportPreferences.Builder#build()} is called immediately and its
         * result is passed to {@link #preferences(ExportPreferences)}.
         * 
         * @param preferences
         *        a consumer that will call methods on {@link ExportPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferences(ExportPreferences)
         */
        default Builder preferences(Consumer<ExportPreferences.Builder> preferences) {
            return preferences(ExportPreferences.builder().applyMutation(preferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<String> exportDataFormat = DefaultSdkAutoConstructList.getInstance();

        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private ExportPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            exportDataFormatWithStrings(model.exportDataFormat);
            filters(model.filters);
            startTime(model.startTime);
            endTime(model.endTime);
            preferences(model.preferences);
        }

        public final Collection<String> getExportDataFormat() {
            if (exportDataFormat instanceof SdkAutoConstructList) {
                return null;
            }
            return exportDataFormat;
        }

        public final void setExportDataFormat(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
        }

        @Override
        public final Builder exportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormatWithStrings(String... exportDataFormat) {
            exportDataFormatWithStrings(Arrays.asList(exportDataFormat));
            return this;
        }

        @Override
        public final Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copyEnumToString(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormat(ExportDataFormat... exportDataFormat) {
            exportDataFormat(Arrays.asList(exportDataFormat));
            return this;
        }

        public final List<ExportFilter.Builder> getFilters() {
            List<ExportFilter.Builder> result = ExportFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ExportFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ExportPreferences.Builder getPreferences() {
            return preferences != null ? preferences.toBuilder() : null;
        }

        public final void setPreferences(ExportPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(ExportPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
