/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopDataCollectionByAgentIdsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<StopDataCollectionByAgentIdsResponse.Builder, StopDataCollectionByAgentIdsResponse> {
    private static final SdkField<List<AgentConfigurationStatus>> AGENTS_CONFIGURATION_STATUS_FIELD = SdkField
            .<List<AgentConfigurationStatus>> builder(MarshallingType.LIST)
            .memberName("agentsConfigurationStatus")
            .getter(getter(StopDataCollectionByAgentIdsResponse::agentsConfigurationStatus))
            .setter(setter(Builder::agentsConfigurationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentsConfigurationStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentConfigurationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentConfigurationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AGENTS_CONFIGURATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AgentConfigurationStatus> agentsConfigurationStatus;

    private StopDataCollectionByAgentIdsResponse(BuilderImpl builder) {
        super(builder);
        this.agentsConfigurationStatus = builder.agentsConfigurationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentsConfigurationStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAgentsConfigurationStatus() {
        return agentsConfigurationStatus != null && !(agentsConfigurationStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the agents that were instructed to stop collecting data. Information includes the agent ID, a
     * description of the operation performed, and whether the agent configuration was updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentsConfigurationStatus} method.
     * </p>
     * 
     * @return Information about the agents that were instructed to stop collecting data. Information includes the agent
     *         ID, a description of the operation performed, and whether the agent configuration was updated.
     */
    public final List<AgentConfigurationStatus> agentsConfigurationStatus() {
        return agentsConfigurationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentsConfigurationStatus() ? agentsConfigurationStatus() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDataCollectionByAgentIdsResponse)) {
            return false;
        }
        StopDataCollectionByAgentIdsResponse other = (StopDataCollectionByAgentIdsResponse) obj;
        return hasAgentsConfigurationStatus() == other.hasAgentsConfigurationStatus()
                && Objects.equals(agentsConfigurationStatus(), other.agentsConfigurationStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopDataCollectionByAgentIdsResponse")
                .add("AgentsConfigurationStatus", hasAgentsConfigurationStatus() ? agentsConfigurationStatus() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentsConfigurationStatus":
            return Optional.ofNullable(clazz.cast(agentsConfigurationStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agentsConfigurationStatus", AGENTS_CONFIGURATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopDataCollectionByAgentIdsResponse, T> g) {
        return obj -> g.apply((StopDataCollectionByAgentIdsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopDataCollectionByAgentIdsResponse> {
        /**
         * <p>
         * Information about the agents that were instructed to stop collecting data. Information includes the agent ID,
         * a description of the operation performed, and whether the agent configuration was updated.
         * </p>
         * 
         * @param agentsConfigurationStatus
         *        Information about the agents that were instructed to stop collecting data. Information includes the
         *        agent ID, a description of the operation performed, and whether the agent configuration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsConfigurationStatus(Collection<AgentConfigurationStatus> agentsConfigurationStatus);

        /**
         * <p>
         * Information about the agents that were instructed to stop collecting data. Information includes the agent ID,
         * a description of the operation performed, and whether the agent configuration was updated.
         * </p>
         * 
         * @param agentsConfigurationStatus
         *        Information about the agents that were instructed to stop collecting data. Information includes the
         *        agent ID, a description of the operation performed, and whether the agent configuration was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentsConfigurationStatus(AgentConfigurationStatus... agentsConfigurationStatus);

        /**
         * <p>
         * Information about the agents that were instructed to stop collecting data. Information includes the agent ID,
         * a description of the operation performed, and whether the agent configuration was updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentConfigurationStatus.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentConfigurationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentConfigurationStatus.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #agentsConfigurationStatus(List<AgentConfigurationStatus>)}.
         * 
         * @param agentsConfigurationStatus
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationdiscovery.model.AgentConfigurationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentsConfigurationStatus(java.util.Collection<AgentConfigurationStatus>)
         */
        Builder agentsConfigurationStatus(Consumer<AgentConfigurationStatus.Builder>... agentsConfigurationStatus);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<AgentConfigurationStatus> agentsConfigurationStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StopDataCollectionByAgentIdsResponse model) {
            super(model);
            agentsConfigurationStatus(model.agentsConfigurationStatus);
        }

        public final List<AgentConfigurationStatus.Builder> getAgentsConfigurationStatus() {
            List<AgentConfigurationStatus.Builder> result = AgentConfigurationStatusListCopier
                    .copyToBuilder(this.agentsConfigurationStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentsConfigurationStatus(Collection<AgentConfigurationStatus.BuilderImpl> agentsConfigurationStatus) {
            this.agentsConfigurationStatus = AgentConfigurationStatusListCopier.copyFromBuilder(agentsConfigurationStatus);
        }

        @Override
        public final Builder agentsConfigurationStatus(Collection<AgentConfigurationStatus> agentsConfigurationStatus) {
            this.agentsConfigurationStatus = AgentConfigurationStatusListCopier.copy(agentsConfigurationStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentsConfigurationStatus(AgentConfigurationStatus... agentsConfigurationStatus) {
            agentsConfigurationStatus(Arrays.asList(agentsConfigurationStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentsConfigurationStatus(Consumer<AgentConfigurationStatus.Builder>... agentsConfigurationStatus) {
            agentsConfigurationStatus(Stream.of(agentsConfigurationStatus)
                    .map(c -> AgentConfigurationStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public StopDataCollectionByAgentIdsResponse build() {
            return new StopDataCollectionByAgentIdsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
