/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryServiceClientConfiguration;
import software.amazon.awssdk.services.applicationdiscovery.internal.ApplicationDiscoveryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryException;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.AssociateConfigurationItemsToApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.AuthorizationErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteAgentsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteAgentsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteImportDataResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ConflictErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.CreateTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteApplicationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DeleteTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeAgentsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeBatchDeleteConfigurationTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeBatchDeleteConfigurationTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeImportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeTagsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.GetDiscoverySummaryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.HomeRegionNotSetException;
import software.amazon.awssdk.services.applicationdiscovery.model.InvalidParameterException;
import software.amazon.awssdk.services.applicationdiscovery.model.InvalidParameterValueException;
import software.amazon.awssdk.services.applicationdiscovery.model.LimitExceededException;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListServerNeighborsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.OperationNotPermittedException;
import software.amazon.awssdk.services.applicationdiscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.applicationdiscovery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.applicationdiscovery.model.ServerInternalErrorException;
import software.amazon.awssdk.services.applicationdiscovery.model.StartBatchDeleteConfigurationTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartBatchDeleteConfigurationTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartExportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StartImportTaskResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopContinuousExportResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.StopDataCollectionByAgentIdsResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.applicationdiscovery.transform.AssociateConfigurationItemsToApplicationRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.BatchDeleteAgentsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.BatchDeleteImportDataRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DeleteApplicationsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeAgentsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeBatchDeleteConfigurationTaskRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeContinuousExportsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeImportTasksRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.DisassociateConfigurationItemsFromApplicationRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.GetDiscoverySummaryRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.ListConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.ListServerNeighborsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StartBatchDeleteConfigurationTaskRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StartContinuousExportRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StartDataCollectionByAgentIdsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StartExportTaskRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StartImportTaskRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StopContinuousExportRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.StopDataCollectionByAgentIdsRequestMarshaller;
import software.amazon.awssdk.services.applicationdiscovery.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultApplicationDiscoveryClient
implements ApplicationDiscoveryClient {
    private static final Logger log = Logger.loggerFor(DefaultApplicationDiscoveryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultApplicationDiscoveryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Application_Discovery_Service#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateConfigurationItemsToApplicationResponse associateConfigurationItemsToApplication(AssociateConfigurationItemsToApplicationRequest associateConfigurationItemsToApplicationRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateConfigurationItemsToApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateConfigurationItemsToApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, associateConfigurationItemsToApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateConfigurationItemsToApplication");
            AssociateConfigurationItemsToApplicationResponse associateConfigurationItemsToApplicationResponse = (AssociateConfigurationItemsToApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateConfigurationItemsToApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateConfigurationItemsToApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateConfigurationItemsToApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateConfigurationItemsToApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$associateConfigurationItemsToApplication$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteAgentsResponse batchDeleteAgents(BatchDeleteAgentsRequest batchDeleteAgentsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteAgentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, batchDeleteAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteAgents");
            BatchDeleteAgentsResponse batchDeleteAgentsResponse = (BatchDeleteAgentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteAgentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteAgentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$batchDeleteAgents$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteImportDataResponse batchDeleteImportData(BatchDeleteImportDataRequest batchDeleteImportDataRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteImportDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteImportDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, batchDeleteImportDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteImportData");
            BatchDeleteImportDataResponse batchDeleteImportDataResponse = (BatchDeleteImportDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteImportData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteImportDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteImportDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteImportDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$batchDeleteImportData$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$createApplication$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$createTags$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationsResponse deleteApplications(DeleteApplicationsRequest deleteApplicationsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, deleteApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplications");
            DeleteApplicationsResponse deleteApplicationsResponse = (DeleteApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$deleteApplications$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$deleteTags$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAgentsResponse describeAgents(DescribeAgentsRequest describeAgentsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAgentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAgentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeAgentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAgents");
            DescribeAgentsResponse describeAgentsResponse = (DescribeAgentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAgents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAgentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAgentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAgentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeAgents$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBatchDeleteConfigurationTaskResponse describeBatchDeleteConfigurationTask(DescribeBatchDeleteConfigurationTaskRequest describeBatchDeleteConfigurationTaskRequest) throws AuthorizationErrorException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBatchDeleteConfigurationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBatchDeleteConfigurationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeBatchDeleteConfigurationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBatchDeleteConfigurationTask");
            DescribeBatchDeleteConfigurationTaskResponse describeBatchDeleteConfigurationTaskResponse = (DescribeBatchDeleteConfigurationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBatchDeleteConfigurationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeBatchDeleteConfigurationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeBatchDeleteConfigurationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeBatchDeleteConfigurationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeBatchDeleteConfigurationTask$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationsResponse describeConfigurations(DescribeConfigurationsRequest describeConfigurationsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeConfigurations");
            DescribeConfigurationsResponse describeConfigurationsResponse = (DescribeConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeConfigurations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContinuousExportsResponse describeContinuousExports(DescribeContinuousExportsRequest describeContinuousExportsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException, ResourceNotFoundException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContinuousExportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeContinuousExportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeContinuousExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContinuousExports");
            DescribeContinuousExportsResponse describeContinuousExportsResponse = (DescribeContinuousExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContinuousExports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeContinuousExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeContinuousExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeContinuousExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeContinuousExports$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeExportTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeExportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExportTasks");
            DescribeExportTasksResponse describeExportTasksResponse = (DescribeExportTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExportTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeExportTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeExportTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeExportTasks$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeImportTasksResponse describeImportTasks(DescribeImportTasksRequest describeImportTasksRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImportTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeImportTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImportTasks");
            DescribeImportTasksResponse describeImportTasksResponse = (DescribeImportTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImportTasks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeImportTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeImportTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeImportTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeImportTasks$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$describeTags$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateConfigurationItemsFromApplicationResponse disassociateConfigurationItemsFromApplication(DisassociateConfigurationItemsFromApplicationRequest disassociateConfigurationItemsFromApplicationRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateConfigurationItemsFromApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateConfigurationItemsFromApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, disassociateConfigurationItemsFromApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateConfigurationItemsFromApplication");
            DisassociateConfigurationItemsFromApplicationResponse disassociateConfigurationItemsFromApplicationResponse = (DisassociateConfigurationItemsFromApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateConfigurationItemsFromApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateConfigurationItemsFromApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateConfigurationItemsFromApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateConfigurationItemsFromApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$disassociateConfigurationItemsFromApplication$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDiscoverySummaryResponse getDiscoverySummary(GetDiscoverySummaryRequest getDiscoverySummaryRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDiscoverySummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDiscoverySummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, getDiscoverySummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDiscoverySummary");
            GetDiscoverySummaryResponse getDiscoverySummaryResponse = (GetDiscoverySummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDiscoverySummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDiscoverySummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDiscoverySummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDiscoverySummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$getDiscoverySummary$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfigurationsResponse listConfigurations(ListConfigurationsRequest listConfigurationsRequest) throws AuthorizationErrorException, ResourceNotFoundException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfigurationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, listConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfigurations");
            ListConfigurationsResponse listConfigurationsResponse = (ListConfigurationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConfigurationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfigurationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$listConfigurations$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServerNeighborsResponse listServerNeighbors(ListServerNeighborsRequest listServerNeighborsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServerNeighborsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServerNeighborsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, listServerNeighborsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServerNeighbors");
            ListServerNeighborsResponse listServerNeighborsResponse = (ListServerNeighborsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServerNeighbors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServerNeighborsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServerNeighborsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServerNeighborsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$listServerNeighbors$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartBatchDeleteConfigurationTaskResponse startBatchDeleteConfigurationTask(StartBatchDeleteConfigurationTaskRequest startBatchDeleteConfigurationTaskRequest) throws LimitExceededException, AuthorizationErrorException, ServerInternalErrorException, HomeRegionNotSetException, OperationNotPermittedException, InvalidParameterValueException, InvalidParameterException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartBatchDeleteConfigurationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startBatchDeleteConfigurationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, startBatchDeleteConfigurationTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartBatchDeleteConfigurationTask");
            StartBatchDeleteConfigurationTaskResponse startBatchDeleteConfigurationTaskResponse = (StartBatchDeleteConfigurationTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartBatchDeleteConfigurationTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startBatchDeleteConfigurationTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartBatchDeleteConfigurationTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startBatchDeleteConfigurationTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$startBatchDeleteConfigurationTask$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartContinuousExportResponse startContinuousExport(StartContinuousExportRequest startContinuousExportRequest) throws ConflictErrorException, AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException, ResourceInUseException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartContinuousExportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startContinuousExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, startContinuousExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartContinuousExport");
            StartContinuousExportResponse startContinuousExportResponse = (StartContinuousExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartContinuousExport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startContinuousExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartContinuousExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startContinuousExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$startContinuousExport$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDataCollectionByAgentIdsResponse startDataCollectionByAgentIds(StartDataCollectionByAgentIdsRequest startDataCollectionByAgentIdsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDataCollectionByAgentIdsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDataCollectionByAgentIdsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, startDataCollectionByAgentIdsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDataCollectionByAgentIds");
            StartDataCollectionByAgentIdsResponse startDataCollectionByAgentIdsResponse = (StartDataCollectionByAgentIdsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDataCollectionByAgentIds").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDataCollectionByAgentIdsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDataCollectionByAgentIdsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDataCollectionByAgentIdsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$startDataCollectionByAgentIds$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExportTaskResponse startExportTask(StartExportTaskRequest startExportTaskRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExportTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startExportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, startExportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExportTask");
            StartExportTaskResponse startExportTaskResponse = (StartExportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startExportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$startExportTask$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartImportTaskResponse startImportTask(StartImportTaskRequest startImportTaskRequest) throws ResourceInUseException, AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartImportTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startImportTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, startImportTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartImportTask");
            StartImportTaskResponse startImportTaskResponse = (StartImportTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartImportTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startImportTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartImportTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startImportTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$startImportTask$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopContinuousExportResponse stopContinuousExport(StopContinuousExportRequest stopContinuousExportRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, OperationNotPermittedException, ResourceNotFoundException, ResourceInUseException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopContinuousExportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopContinuousExportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, stopContinuousExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopContinuousExport");
            StopContinuousExportResponse stopContinuousExportResponse = (StopContinuousExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopContinuousExport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopContinuousExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopContinuousExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopContinuousExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$stopContinuousExport$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopDataCollectionByAgentIdsResponse stopDataCollectionByAgentIds(StopDataCollectionByAgentIdsRequest stopDataCollectionByAgentIdsRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopDataCollectionByAgentIdsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopDataCollectionByAgentIdsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, stopDataCollectionByAgentIdsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopDataCollectionByAgentIds");
            StopDataCollectionByAgentIdsResponse stopDataCollectionByAgentIdsResponse = (StopDataCollectionByAgentIdsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopDataCollectionByAgentIds").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopDataCollectionByAgentIdsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopDataCollectionByAgentIdsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopDataCollectionByAgentIdsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$stopDataCollectionByAgentIds$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws AuthorizationErrorException, InvalidParameterException, InvalidParameterValueException, ServerInternalErrorException, HomeRegionNotSetException, AwsServiceException, SdkClientException, ApplicationDiscoveryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServerInternalErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServerInternalErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ServerInternalErrorException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "InvalidParameterValueException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                }
                case "ResourceInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                }
                case "ConflictErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictErrorException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "LimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "HomeRegionNotSetException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("HomeRegionNotSetException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(HomeRegionNotSetException::builder).build());
                }
                case "AuthorizationErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AuthorizationErrorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AuthorizationErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultApplicationDiscoveryClient.resolveMetricPublishers(clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Application Discovery Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            UpdateApplicationResponse updateApplicationResponse = (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultApplicationDiscoveryClient.lambda$updateApplication$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "discovery";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        ApplicationDiscoveryServiceClientConfigurationBuilder serviceConfigBuilder = new ApplicationDiscoveryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ApplicationDiscoveryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final ApplicationDiscoveryServiceClientConfiguration serviceClientConfiguration() {
        return new ApplicationDiscoveryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateApplication$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopDataCollectionByAgentIds$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopContinuousExport$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startImportTask$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExportTask$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDataCollectionByAgentIds$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startContinuousExport$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startBatchDeleteConfigurationTask$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServerNeighbors$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfigurations$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDiscoverySummary$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateConfigurationItemsFromApplication$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImportTasks$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExportTasks$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContinuousExports$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeConfigurations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBatchDeleteConfigurationTask$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAgents$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplications$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteImportData$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteAgents$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateConfigurationItemsToApplication$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

