/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Network details about the host where the agent/connector resides.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentNetworkInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentNetworkInfo.Builder, AgentNetworkInfo> {
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgentNetworkInfo::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()).build();

    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AgentNetworkInfo::macAddress)).setter(setter(Builder::macAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_FIELD,
            MAC_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddress;

    private final String macAddress;

    private AgentNetworkInfo(BuilderImpl builder) {
        this.ipAddress = builder.ipAddress;
        this.macAddress = builder.macAddress;
    }

    /**
     * <p>
     * The IP address for the host where the agent/connector resides.
     * </p>
     * 
     * @return The IP address for the host where the agent/connector resides.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The MAC address for the host where the agent/connector resides.
     * </p>
     * 
     * @return The MAC address for the host where the agent/connector resides.
     */
    public String macAddress() {
        return macAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(macAddress());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentNetworkInfo)) {
            return false;
        }
        AgentNetworkInfo other = (AgentNetworkInfo) obj;
        return Objects.equals(ipAddress(), other.ipAddress()) && Objects.equals(macAddress(), other.macAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AgentNetworkInfo").add("IpAddress", ipAddress()).add("MacAddress", macAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ipAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "macAddress":
            return Optional.ofNullable(clazz.cast(macAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentNetworkInfo, T> g) {
        return obj -> g.apply((AgentNetworkInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentNetworkInfo> {
        /**
         * <p>
         * The IP address for the host where the agent/connector resides.
         * </p>
         * 
         * @param ipAddress
         *        The IP address for the host where the agent/connector resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The MAC address for the host where the agent/connector resides.
         * </p>
         * 
         * @param macAddress
         *        The MAC address for the host where the agent/connector resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macAddress(String macAddress);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddress;

        private String macAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentNetworkInfo model) {
            ipAddress(model.ipAddress);
            macAddress(model.macAddress);
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getMacAddress() {
            return macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public AgentNetworkInfo build() {
            return new AgentNetworkInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
