/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeConfigurationsResponse.Builder, DescribeConfigurationsResponse> {
    private static final SdkField<List<Map<String, String>>> CONFIGURATIONS_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .getter(getter(DescribeConfigurationsResponse::configurations))
            .setter(setter(Builder::configurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD));

    private final List<Map<String, String>> configurations;

    private DescribeConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
    }

    /**
     * <p>
     * A key in the response map. The value is an array of data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A key in the response map. The value is an array of data.
     */
    public List<Map<String, String>> configurations() {
        return configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationsResponse)) {
            return false;
        }
        DescribeConfigurationsResponse other = (DescribeConfigurationsResponse) obj;
        return Objects.equals(configurations(), other.configurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeConfigurationsResponse").add("Configurations", configurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationsResponse> {
        /**
         * <p>
         * A key in the response map. The value is an array of data.
         * </p>
         * 
         * @param configurations
         *        A key in the response map. The value is an array of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Collection<? extends Map<String, String>> configurations);

        /**
         * <p>
         * A key in the response map. The value is an array of data.
         * </p>
         * 
         * @param configurations
         *        A key in the response map. The value is an array of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Map<String, String>... configurations);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<Map<String, String>> configurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationsResponse model) {
            super(model);
            configurations(model.configurations);
        }

        public final Collection<? extends Map<String, String>> getConfigurations() {
            return configurations;
        }

        @Override
        public final Builder configurations(Collection<? extends Map<String, String>> configurations) {
            this.configurations = DescribeConfigurationsAttributesCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Map<String, String>... configurations) {
            configurations(Arrays.asList(configurations));
            return this;
        }

        public final void setConfigurations(Collection<? extends Map<String, String>> configurations) {
            this.configurations = DescribeConfigurationsAttributesCopier.copy(configurations);
        }

        @Override
        public DescribeConfigurationsResponse build() {
            return new DescribeConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
