/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportTasksResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<DescribeImportTasksResponse.Builder, DescribeImportTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeImportTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ImportTask>> TASKS_FIELD = SdkField
            .<List<ImportTask>> builder(MarshallingType.LIST)
            .getter(getter(DescribeImportTasksResponse::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TASKS_FIELD));

    private final String nextToken;

    private final List<ImportTask> tasks;

    private DescribeImportTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tasks = builder.tasks;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A returned array of import tasks that match any applied filters, up to the specified number of maximum results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A returned array of import tasks that match any applied filters, up to the specified number of maximum
     *         results.
     */
    public List<ImportTask> tasks() {
        return tasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportTasksResponse)) {
            return false;
        }
        DescribeImportTasksResponse other = (DescribeImportTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tasks(), other.tasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeImportTasksResponse").add("NextToken", nextToken()).add("Tasks", tasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportTasksResponse, T> g) {
        return obj -> g.apply((DescribeImportTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeImportTasksResponse> {
        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A returned array of import tasks that match any applied filters, up to the specified number of maximum
         * results.
         * </p>
         * 
         * @param tasks
         *        A returned array of import tasks that match any applied filters, up to the specified number of maximum
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<ImportTask> tasks);

        /**
         * <p>
         * A returned array of import tasks that match any applied filters, up to the specified number of maximum
         * results.
         * </p>
         * 
         * @param tasks
         *        A returned array of import tasks that match any applied filters, up to the specified number of maximum
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(ImportTask... tasks);

        /**
         * <p>
         * A returned array of import tasks that match any applied filters, up to the specified number of maximum
         * results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportTask>.Builder} avoiding the need to
         * create one manually via {@link List<ImportTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportTask>.Builder#build()} is called immediately and its
         * result is passed to {@link #tasks(List<ImportTask>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<ImportTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<ImportTask>)
         */
        Builder tasks(Consumer<ImportTask.Builder>... tasks);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ImportTask> tasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            tasks(model.tasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ImportTask.Builder> getTasks() {
            return tasks != null ? tasks.stream().map(ImportTask::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tasks(Collection<ImportTask> tasks) {
            this.tasks = ImportTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(ImportTask... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<ImportTask.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> ImportTask.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTasks(Collection<ImportTask.BuilderImpl> tasks) {
            this.tasks = ImportTaskListCopier.copyFromBuilder(tasks);
        }

        @Override
        public DescribeImportTasksResponse build() {
            return new DescribeImportTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
