/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationComponent.getter(ApplicationComponent::componentName)).setter(ApplicationComponent.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationComponent.getter(ApplicationComponent::resourceType)).setter(ApplicationComponent.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ApplicationComponent.getter(ApplicationComponent::tierAsString)).setter(ApplicationComponent.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ApplicationComponent.getter(ApplicationComponent::monitor)).setter(ApplicationComponent.setter(Builder::monitor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, RESOURCE_TYPE_FIELD, TIER_FIELD, MONITOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String resourceType;
    private final String tier;
    private final Boolean monitor;

    private ApplicationComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.resourceType = builder.resourceType;
        this.tier = builder.tier;
        this.monitor = builder.monitor;
    }

    public String componentName() {
        return this.componentName;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public String tierAsString() {
        return this.tier;
    }

    public Boolean monitor() {
        return this.monitor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponent)) {
            return false;
        }
        ApplicationComponent other = (ApplicationComponent)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.monitor(), other.monitor());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationComponent").add("ComponentName", (Object)this.componentName()).add("ResourceType", (Object)this.resourceType()).add("Tier", (Object)this.tierAsString()).add("Monitor", (Object)this.monitor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "Monitor": {
                return Optional.ofNullable(clazz.cast(this.monitor()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponent, T> g) {
        return obj -> g.apply((ApplicationComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String resourceType;
        private String tier;
        private Boolean monitor;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponent model) {
            this.componentName(model.componentName);
            this.resourceType(model.resourceType);
            this.tier(model.tier);
            this.monitor(model.monitor);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTierAsString() {
            return this.tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        public final Boolean getMonitor() {
            return this.monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        public ApplicationComponent build() {
            return new ApplicationComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationComponent> {
        public Builder componentName(String var1);

        public Builder resourceType(String var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder monitor(Boolean var1);
    }
}

