/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackCopier;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackKey;
import software.amazon.awssdk.services.applicationinsights.model.FeedbackValue;
import software.amazon.awssdk.services.applicationinsights.model.SeverityLevel;
import software.amazon.awssdk.services.applicationinsights.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Problem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Problem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::id)).setter(Problem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::title)).setter(Problem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::insights)).setter(Problem.setter(Builder::insights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insights").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::statusAsString)).setter(Problem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AFFECTED_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::affectedResource)).setter(Problem.setter(Builder::affectedResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedResource").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Problem.getter(Problem::startTime)).setter(Problem.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Problem.getter(Problem::endTime)).setter(Problem.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SEVERITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::severityLevelAsString)).setter(Problem.setter(Builder::severityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLevel").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Problem.getter(Problem::resourceGroupName)).setter(Problem.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<Map<String, String>> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(Problem.getter(Problem::feedbackAsStrings)).setter(Problem.setter(Builder::feedbackWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, INSIGHTS_FIELD, STATUS_FIELD, AFFECTED_RESOURCE_FIELD, START_TIME_FIELD, END_TIME_FIELD, SEVERITY_LEVEL_FIELD, RESOURCE_GROUP_NAME_FIELD, FEEDBACK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final String insights;
    private final String status;
    private final String affectedResource;
    private final Instant startTime;
    private final Instant endTime;
    private final String severityLevel;
    private final String resourceGroupName;
    private final Map<String, String> feedback;

    private Problem(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.insights = builder.insights;
        this.status = builder.status;
        this.affectedResource = builder.affectedResource;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.severityLevel = builder.severityLevel;
        this.resourceGroupName = builder.resourceGroupName;
        this.feedback = builder.feedback;
    }

    public String id() {
        return this.id;
    }

    public String title() {
        return this.title;
    }

    public String insights() {
        return this.insights;
    }

    public Status status() {
        return Status.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String affectedResource() {
        return this.affectedResource;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public SeverityLevel severityLevel() {
        return SeverityLevel.fromValue(this.severityLevel);
    }

    public String severityLevelAsString() {
        return this.severityLevel;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public Map<FeedbackKey, FeedbackValue> feedback() {
        return FeedbackCopier.copyStringToEnum(this.feedback);
    }

    public boolean hasFeedback() {
        return this.feedback != null && !(this.feedback instanceof SdkAutoConstructMap);
    }

    public Map<String, String> feedbackAsStrings() {
        return this.feedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.insights());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.affectedResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.insights(), other.insights()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.affectedResource(), other.affectedResource()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.severityLevelAsString(), other.severityLevelAsString()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.feedbackAsStrings(), other.feedbackAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Problem").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Insights", (Object)this.insights()).add("Status", (Object)this.statusAsString()).add("AffectedResource", (Object)this.affectedResource()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("SeverityLevel", (Object)this.severityLevelAsString()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("Feedback", this.feedbackAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Insights": {
                return Optional.ofNullable(clazz.cast(this.insights()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AffectedResource": {
                return Optional.ofNullable(clazz.cast(this.affectedResource()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "SeverityLevel": {
                return Optional.ofNullable(clazz.cast(this.severityLevelAsString()));
            }
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Problem, T> g) {
        return obj -> g.apply((Problem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private String insights;
        private String status;
        private String affectedResource;
        private Instant startTime;
        private Instant endTime;
        private String severityLevel;
        private String resourceGroupName;
        private Map<String, String> feedback = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Problem model) {
            this.id(model.id);
            this.title(model.title);
            this.insights(model.insights);
            this.status(model.status);
            this.affectedResource(model.affectedResource);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.severityLevel(model.severityLevel);
            this.resourceGroupName(model.resourceGroupName);
            this.feedbackWithStrings(model.feedback);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getInsights() {
            return this.insights;
        }

        @Override
        public final Builder insights(String insights) {
            this.insights = insights;
            return this;
        }

        public final void setInsights(String insights) {
            this.insights = insights;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getAffectedResource() {
            return this.affectedResource;
        }

        @Override
        public final Builder affectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
            return this;
        }

        public final void setAffectedResource(String affectedResource) {
            this.affectedResource = affectedResource;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getSeverityLevelAsString() {
            return this.severityLevel;
        }

        @Override
        public final Builder severityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
            return this;
        }

        @Override
        public final Builder severityLevel(SeverityLevel severityLevel) {
            this.severityLevel(severityLevel == null ? null : severityLevel.toString());
            return this;
        }

        public final void setSeverityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final Map<String, String> getFeedbackAsStrings() {
            return this.feedback;
        }

        @Override
        public final Builder feedbackWithStrings(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
            return this;
        }

        @Override
        public final Builder feedback(Map<FeedbackKey, FeedbackValue> feedback) {
            this.feedback = FeedbackCopier.copyEnumToString(feedback);
            return this;
        }

        public final void setFeedbackWithStrings(Map<String, String> feedback) {
            this.feedback = FeedbackCopier.copy(feedback);
        }

        public Problem build() {
            return new Problem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Problem> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder insights(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder affectedResource(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder severityLevel(String var1);

        public Builder severityLevel(SeverityLevel var1);

        public Builder resourceGroupName(String var1);

        public Builder feedbackWithStrings(Map<String, String> var1);

        public Builder feedback(Map<FeedbackKey, FeedbackValue> var1);
    }
}

