/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Tier {
    DEFAULT("DEFAULT"),
    DOT_NET_CORE("DOT_NET_CORE"),
    DOT_NET_WORKER("DOT_NET_WORKER"),
    DOT_NET_WEB("DOT_NET_WEB"),
    SQL_SERVER("SQL_SERVER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Tier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Tier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Tier.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Tier> knownValues() {
        return Stream.of(Tier.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

