/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationInfo> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(ApplicationInfo.getter(ApplicationInfo::resourceGroupName)).setter(ApplicationInfo.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifeCycle").getter(ApplicationInfo.getter(ApplicationInfo::lifeCycle)).setter(ApplicationInfo.setter(Builder::lifeCycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()}).build();
    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpsItemSNSTopicArn").getter(ApplicationInfo.getter(ApplicationInfo::opsItemSNSTopicArn)).setter(ApplicationInfo.setter(Builder::opsItemSNSTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build()}).build();
    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OpsCenterEnabled").getter(ApplicationInfo.getter(ApplicationInfo::opsCenterEnabled)).setter(ApplicationInfo.setter(Builder::opsCenterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()}).build();
    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CWEMonitorEnabled").getter(ApplicationInfo.getter(ApplicationInfo::cweMonitorEnabled)).setter(ApplicationInfo.setter(Builder::cweMonitorEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()}).build();
    private static final SdkField<String> REMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Remarks").getter(ApplicationInfo.getter(ApplicationInfo::remarks)).setter(ApplicationInfo.setter(Builder::remarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remarks").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, LIFE_CYCLE_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, REMARKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceGroupName;
    private final String lifeCycle;
    private final String opsItemSNSTopicArn;
    private final Boolean opsCenterEnabled;
    private final Boolean cweMonitorEnabled;
    private final String remarks;

    private ApplicationInfo(BuilderImpl builder) {
        this.resourceGroupName = builder.resourceGroupName;
        this.lifeCycle = builder.lifeCycle;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.remarks = builder.remarks;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String lifeCycle() {
        return this.lifeCycle;
    }

    public String opsItemSNSTopicArn() {
        return this.opsItemSNSTopicArn;
    }

    public Boolean opsCenterEnabled() {
        return this.opsCenterEnabled;
    }

    public Boolean cweMonitorEnabled() {
        return this.cweMonitorEnabled;
    }

    public String remarks() {
        return this.remarks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.remarks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo)obj;
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.opsItemSNSTopicArn(), other.opsItemSNSTopicArn()) && Objects.equals(this.opsCenterEnabled(), other.opsCenterEnabled()) && Objects.equals(this.cweMonitorEnabled(), other.cweMonitorEnabled()) && Objects.equals(this.remarks(), other.remarks());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationInfo").add("ResourceGroupName", (Object)this.resourceGroupName()).add("LifeCycle", (Object)this.lifeCycle()).add("OpsItemSNSTopicArn", (Object)this.opsItemSNSTopicArn()).add("OpsCenterEnabled", (Object)this.opsCenterEnabled()).add("CWEMonitorEnabled", (Object)this.cweMonitorEnabled()).add("Remarks", (Object)this.remarks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "LifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "OpsItemSNSTopicArn": {
                return Optional.ofNullable(clazz.cast(this.opsItemSNSTopicArn()));
            }
            case "OpsCenterEnabled": {
                return Optional.ofNullable(clazz.cast(this.opsCenterEnabled()));
            }
            case "CWEMonitorEnabled": {
                return Optional.ofNullable(clazz.cast(this.cweMonitorEnabled()));
            }
            case "Remarks": {
                return Optional.ofNullable(clazz.cast(this.remarks()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInfo, T> g) {
        return obj -> g.apply((ApplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String lifeCycle;
        private String opsItemSNSTopicArn;
        private Boolean opsCenterEnabled;
        private Boolean cweMonitorEnabled;
        private String remarks;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            this.resourceGroupName(model.resourceGroupName);
            this.lifeCycle(model.lifeCycle);
            this.opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            this.opsCenterEnabled(model.opsCenterEnabled);
            this.cweMonitorEnabled(model.cweMonitorEnabled);
            this.remarks(model.remarks);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final String getLifeCycle() {
            return this.lifeCycle;
        }

        @Override
        public final Builder lifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final void setLifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
        }

        public final String getOpsItemSNSTopicArn() {
            return this.opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        public final Boolean getOpsCenterEnabled() {
            return this.opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        public final Boolean getCweMonitorEnabled() {
            return this.cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        public final String getRemarks() {
            return this.remarks;
        }

        @Override
        public final Builder remarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        public final void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationInfo> {
        public Builder resourceGroupName(String var1);

        public Builder lifeCycle(String var1);

        public Builder opsItemSNSTopicArn(String var1);

        public Builder opsCenterEnabled(Boolean var1);

        public Builder cweMonitorEnabled(Boolean var1);

        public Builder remarks(String var1);
    }
}

