/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventResourceType;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationEvent> {
    private static final SdkField<String> MONITORED_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoredResourceARN").getter(ConfigurationEvent.getter(ConfigurationEvent::monitoredResourceARN)).setter(ConfigurationEvent.setter(Builder::monitoredResourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceARN").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventStatus").getter(ConfigurationEvent.getter(ConfigurationEvent::eventStatusAsString)).setter(ConfigurationEvent.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStatus").build()}).build();
    private static final SdkField<String> EVENT_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventResourceType").getter(ConfigurationEvent.getter(ConfigurationEvent::eventResourceTypeAsString)).setter(ConfigurationEvent.setter(Builder::eventResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceType").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(ConfigurationEvent.getter(ConfigurationEvent::eventTime)).setter(ConfigurationEvent.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<String> EVENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDetail").getter(ConfigurationEvent.getter(ConfigurationEvent::eventDetail)).setter(ConfigurationEvent.setter(Builder::eventDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetail").build()}).build();
    private static final SdkField<String> EVENT_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventResourceName").getter(ConfigurationEvent.getter(ConfigurationEvent::eventResourceName)).setter(ConfigurationEvent.setter(Builder::eventResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORED_RESOURCE_ARN_FIELD, EVENT_STATUS_FIELD, EVENT_RESOURCE_TYPE_FIELD, EVENT_TIME_FIELD, EVENT_DETAIL_FIELD, EVENT_RESOURCE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitoredResourceARN;
    private final String eventStatus;
    private final String eventResourceType;
    private final Instant eventTime;
    private final String eventDetail;
    private final String eventResourceName;

    private ConfigurationEvent(BuilderImpl builder) {
        this.monitoredResourceARN = builder.monitoredResourceARN;
        this.eventStatus = builder.eventStatus;
        this.eventResourceType = builder.eventResourceType;
        this.eventTime = builder.eventTime;
        this.eventDetail = builder.eventDetail;
        this.eventResourceName = builder.eventResourceName;
    }

    public String monitoredResourceARN() {
        return this.monitoredResourceARN;
    }

    public ConfigurationEventStatus eventStatus() {
        return ConfigurationEventStatus.fromValue(this.eventStatus);
    }

    public String eventStatusAsString() {
        return this.eventStatus;
    }

    public ConfigurationEventResourceType eventResourceType() {
        return ConfigurationEventResourceType.fromValue(this.eventResourceType);
    }

    public String eventResourceTypeAsString() {
        return this.eventResourceType;
    }

    public Instant eventTime() {
        return this.eventTime;
    }

    public String eventDetail() {
        return this.eventDetail;
    }

    public String eventResourceName() {
        return this.eventResourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventResourceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent)obj;
        return Objects.equals(this.monitoredResourceARN(), other.monitoredResourceARN()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString()) && Objects.equals(this.eventResourceTypeAsString(), other.eventResourceTypeAsString()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.eventDetail(), other.eventDetail()) && Objects.equals(this.eventResourceName(), other.eventResourceName());
    }

    public String toString() {
        return ToString.builder((String)"ConfigurationEvent").add("MonitoredResourceARN", (Object)this.monitoredResourceARN()).add("EventStatus", (Object)this.eventStatusAsString()).add("EventResourceType", (Object)this.eventResourceTypeAsString()).add("EventTime", (Object)this.eventTime()).add("EventDetail", (Object)this.eventDetail()).add("EventResourceName", (Object)this.eventResourceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoredResourceARN": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceARN()));
            }
            case "EventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
            case "EventResourceType": {
                return Optional.ofNullable(clazz.cast(this.eventResourceTypeAsString()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "EventDetail": {
                return Optional.ofNullable(clazz.cast(this.eventDetail()));
            }
            case "EventResourceName": {
                return Optional.ofNullable(clazz.cast(this.eventResourceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoredResourceARN;
        private String eventStatus;
        private String eventResourceType;
        private Instant eventTime;
        private String eventDetail;
        private String eventResourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationEvent model) {
            this.monitoredResourceARN(model.monitoredResourceARN);
            this.eventStatus(model.eventStatus);
            this.eventResourceType(model.eventResourceType);
            this.eventTime(model.eventTime);
            this.eventDetail(model.eventDetail);
            this.eventResourceName(model.eventResourceName);
        }

        public final String getMonitoredResourceARN() {
            return this.monitoredResourceARN;
        }

        @Override
        public final Builder monitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
            return this;
        }

        public final void setMonitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(ConfigurationEventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        public final String getEventResourceType() {
            return this.eventResourceType;
        }

        @Override
        public final Builder eventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
            return this;
        }

        @Override
        public final Builder eventResourceType(ConfigurationEventResourceType eventResourceType) {
            this.eventResourceType(eventResourceType == null ? null : eventResourceType.toString());
            return this;
        }

        public final void setEventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        public final String getEventDetail() {
            return this.eventDetail;
        }

        @Override
        public final Builder eventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
            return this;
        }

        public final void setEventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
        }

        public final String getEventResourceName() {
            return this.eventResourceName;
        }

        @Override
        public final Builder eventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
            return this;
        }

        public final void setEventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
        }

        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationEvent> {
        public Builder monitoredResourceARN(String var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(ConfigurationEventStatus var1);

        public Builder eventResourceType(String var1);

        public Builder eventResourceType(ConfigurationEventResourceType var1);

        public Builder eventTime(Instant var1);

        public Builder eventDetail(String var1);

        public Builder eventResourceName(String var1);
    }
}

