/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLogPatternRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, CreateLogPatternRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(CreateLogPatternRequest.getter(CreateLogPatternRequest::resourceGroupName)).setter(CreateLogPatternRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternSetName").getter(CreateLogPatternRequest.getter(CreateLogPatternRequest::patternSetName)).setter(CreateLogPatternRequest.setter(Builder::patternSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()}).build();
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternName").getter(CreateLogPatternRequest.getter(CreateLogPatternRequest::patternName)).setter(CreateLogPatternRequest.setter(Builder::patternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Pattern").getter(CreateLogPatternRequest.getter(CreateLogPatternRequest::pattern)).setter(CreateLogPatternRequest.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()}).build();
    private static final SdkField<Integer> RANK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Rank").getter(CreateLogPatternRequest.getter(CreateLogPatternRequest::rank)).setter(CreateLogPatternRequest.setter(Builder::rank)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rank").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, PATTERN_SET_NAME_FIELD, PATTERN_NAME_FIELD, PATTERN_FIELD, RANK_FIELD));
    private final String resourceGroupName;
    private final String patternSetName;
    private final String patternName;
    private final String pattern;
    private final Integer rank;

    private CreateLogPatternRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
        this.pattern = builder.pattern;
        this.rank = builder.rank;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String patternSetName() {
        return this.patternSetName;
    }

    public String patternName() {
        return this.patternName;
    }

    public String pattern() {
        return this.pattern;
    }

    public Integer rank() {
        return this.rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.rank());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLogPatternRequest)) {
            return false;
        }
        CreateLogPatternRequest other = (CreateLogPatternRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.patternSetName(), other.patternSetName()) && Objects.equals(this.patternName(), other.patternName()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.rank(), other.rank());
    }

    public String toString() {
        return ToString.builder((String)"CreateLogPatternRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("PatternSetName", (Object)this.patternSetName()).add("PatternName", (Object)this.patternName()).add("Pattern", (Object)this.pattern()).add("Rank", (Object)this.rank()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "PatternSetName": {
                return Optional.ofNullable(clazz.cast(this.patternSetName()));
            }
            case "PatternName": {
                return Optional.ofNullable(clazz.cast(this.patternName()));
            }
            case "Pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "Rank": {
                return Optional.ofNullable(clazz.cast(this.rank()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLogPatternRequest, T> g) {
        return obj -> g.apply((CreateLogPatternRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String patternSetName;
        private String patternName;
        private String pattern;
        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLogPatternRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.patternSetName(model.patternSetName);
            this.patternName(model.patternName);
            this.pattern(model.pattern);
            this.rank(model.rank);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        public final String getPatternSetName() {
            return this.patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        public final String getPatternName() {
            return this.patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        public final String getPattern() {
            return this.pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public final Integer getRank() {
            return this.rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLogPatternRequest build() {
            return new CreateLogPatternRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLogPatternRequest> {
        public Builder resourceGroupName(String var1);

        public Builder patternSetName(String var1);

        public Builder patternName(String var1);

        public Builder pattern(String var1);

        public Builder rank(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

