/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.CloudWatchEventSource;
import software.amazon.awssdk.services.applicationinsights.model.LogFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Observation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Observation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Observation.getter(Observation::id)).setter(Observation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Observation.getter(Observation::startTime)).setter(Observation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(Observation.getter(Observation::endTime)).setter(Observation.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(Observation.getter(Observation::sourceType)).setter(Observation.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceARN").getter(Observation.getter(Observation::sourceARN)).setter(Observation.setter(Builder::sourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceARN").build()}).build();
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroup").getter(Observation.getter(Observation::logGroup)).setter(Observation.setter(Builder::logGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroup").build()}).build();
    private static final SdkField<Instant> LINE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LineTime").getter(Observation.getter(Observation::lineTime)).setter(Observation.setter(Builder::lineTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineTime").build()}).build();
    private static final SdkField<String> LOG_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogText").getter(Observation.getter(Observation::logText)).setter(Observation.setter(Builder::logText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogText").build()}).build();
    private static final SdkField<String> LOG_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFilter").getter(Observation.getter(Observation::logFilterAsString)).setter(Observation.setter(Builder::logFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilter").build()}).build();
    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricNamespace").getter(Observation.getter(Observation::metricNamespace)).setter(Observation.setter(Builder::metricNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(Observation.getter(Observation::metricName)).setter(Observation.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Observation.getter(Observation::unit)).setter(Observation.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(Observation.getter(Observation::value)).setter(Observation.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchEventId").getter(Observation.getter(Observation::cloudWatchEventId)).setter(Observation.setter(Builder::cloudWatchEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventId").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchEventSource").getter(Observation.getter(Observation::cloudWatchEventSourceAsString)).setter(Observation.setter(Builder::cloudWatchEventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventSource").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_EVENT_DETAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchEventDetailType").getter(Observation.getter(Observation::cloudWatchEventDetailType)).setter(Observation.setter(Builder::cloudWatchEventDetailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEventDetailType").build()}).build();
    private static final SdkField<String> HEALTH_EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthEventArn").getter(Observation.getter(Observation::healthEventArn)).setter(Observation.setter(Builder::healthEventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventArn").build()}).build();
    private static final SdkField<String> HEALTH_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthService").getter(Observation.getter(Observation::healthService)).setter(Observation.setter(Builder::healthService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthService").build()}).build();
    private static final SdkField<String> HEALTH_EVENT_TYPE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthEventTypeCode").getter(Observation.getter(Observation::healthEventTypeCode)).setter(Observation.setter(Builder::healthEventTypeCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventTypeCode").build()}).build();
    private static final SdkField<String> HEALTH_EVENT_TYPE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthEventTypeCategory").getter(Observation.getter(Observation::healthEventTypeCategory)).setter(Observation.setter(Builder::healthEventTypeCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventTypeCategory").build()}).build();
    private static final SdkField<String> HEALTH_EVENT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthEventDescription").getter(Observation.getter(Observation::healthEventDescription)).setter(Observation.setter(Builder::healthEventDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthEventDescription").build()}).build();
    private static final SdkField<String> CODE_DEPLOY_DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeDeployDeploymentId").getter(Observation.getter(Observation::codeDeployDeploymentId)).setter(Observation.setter(Builder::codeDeployDeploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployDeploymentId").build()}).build();
    private static final SdkField<String> CODE_DEPLOY_DEPLOYMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeDeployDeploymentGroup").getter(Observation.getter(Observation::codeDeployDeploymentGroup)).setter(Observation.setter(Builder::codeDeployDeploymentGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployDeploymentGroup").build()}).build();
    private static final SdkField<String> CODE_DEPLOY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeDeployState").getter(Observation.getter(Observation::codeDeployState)).setter(Observation.setter(Builder::codeDeployState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployState").build()}).build();
    private static final SdkField<String> CODE_DEPLOY_APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeDeployApplication").getter(Observation.getter(Observation::codeDeployApplication)).setter(Observation.setter(Builder::codeDeployApplication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployApplication").build()}).build();
    private static final SdkField<String> CODE_DEPLOY_INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeDeployInstanceGroupId").getter(Observation.getter(Observation::codeDeployInstanceGroupId)).setter(Observation.setter(Builder::codeDeployInstanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeDeployInstanceGroupId").build()}).build();
    private static final SdkField<String> EC2_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2State").getter(Observation.getter(Observation::ec2State)).setter(Observation.setter(Builder::ec2State)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2State").build()}).build();
    private static final SdkField<Integer> X_RAY_FAULT_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XRayFaultPercent").getter(Observation.getter(Observation::xRayFaultPercent)).setter(Observation.setter(Builder::xRayFaultPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayFaultPercent").build()}).build();
    private static final SdkField<Integer> X_RAY_THROTTLE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XRayThrottlePercent").getter(Observation.getter(Observation::xRayThrottlePercent)).setter(Observation.setter(Builder::xRayThrottlePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayThrottlePercent").build()}).build();
    private static final SdkField<Integer> X_RAY_ERROR_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XRayErrorPercent").getter(Observation.getter(Observation::xRayErrorPercent)).setter(Observation.setter(Builder::xRayErrorPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayErrorPercent").build()}).build();
    private static final SdkField<Integer> X_RAY_REQUEST_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XRayRequestCount").getter(Observation.getter(Observation::xRayRequestCount)).setter(Observation.setter(Builder::xRayRequestCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayRequestCount").build()}).build();
    private static final SdkField<Long> X_RAY_REQUEST_AVERAGE_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("XRayRequestAverageLatency").getter(Observation.getter(Observation::xRayRequestAverageLatency)).setter(Observation.setter(Builder::xRayRequestAverageLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayRequestAverageLatency").build()}).build();
    private static final SdkField<String> X_RAY_NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XRayNodeName").getter(Observation.getter(Observation::xRayNodeName)).setter(Observation.setter(Builder::xRayNodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayNodeName").build()}).build();
    private static final SdkField<String> X_RAY_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("XRayNodeType").getter(Observation.getter(Observation::xRayNodeType)).setter(Observation.setter(Builder::xRayNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XRayNodeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, SOURCE_TYPE_FIELD, SOURCE_ARN_FIELD, LOG_GROUP_FIELD, LINE_TIME_FIELD, LOG_TEXT_FIELD, LOG_FILTER_FIELD, METRIC_NAMESPACE_FIELD, METRIC_NAME_FIELD, UNIT_FIELD, VALUE_FIELD, CLOUD_WATCH_EVENT_ID_FIELD, CLOUD_WATCH_EVENT_SOURCE_FIELD, CLOUD_WATCH_EVENT_DETAIL_TYPE_FIELD, HEALTH_EVENT_ARN_FIELD, HEALTH_SERVICE_FIELD, HEALTH_EVENT_TYPE_CODE_FIELD, HEALTH_EVENT_TYPE_CATEGORY_FIELD, HEALTH_EVENT_DESCRIPTION_FIELD, CODE_DEPLOY_DEPLOYMENT_ID_FIELD, CODE_DEPLOY_DEPLOYMENT_GROUP_FIELD, CODE_DEPLOY_STATE_FIELD, CODE_DEPLOY_APPLICATION_FIELD, CODE_DEPLOY_INSTANCE_GROUP_ID_FIELD, EC2_STATE_FIELD, X_RAY_FAULT_PERCENT_FIELD, X_RAY_THROTTLE_PERCENT_FIELD, X_RAY_ERROR_PERCENT_FIELD, X_RAY_REQUEST_COUNT_FIELD, X_RAY_REQUEST_AVERAGE_LATENCY_FIELD, X_RAY_NODE_NAME_FIELD, X_RAY_NODE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant startTime;
    private final Instant endTime;
    private final String sourceType;
    private final String sourceARN;
    private final String logGroup;
    private final Instant lineTime;
    private final String logText;
    private final String logFilter;
    private final String metricNamespace;
    private final String metricName;
    private final String unit;
    private final Double value;
    private final String cloudWatchEventId;
    private final String cloudWatchEventSource;
    private final String cloudWatchEventDetailType;
    private final String healthEventArn;
    private final String healthService;
    private final String healthEventTypeCode;
    private final String healthEventTypeCategory;
    private final String healthEventDescription;
    private final String codeDeployDeploymentId;
    private final String codeDeployDeploymentGroup;
    private final String codeDeployState;
    private final String codeDeployApplication;
    private final String codeDeployInstanceGroupId;
    private final String ec2State;
    private final Integer xRayFaultPercent;
    private final Integer xRayThrottlePercent;
    private final Integer xRayErrorPercent;
    private final Integer xRayRequestCount;
    private final Long xRayRequestAverageLatency;
    private final String xRayNodeName;
    private final String xRayNodeType;

    private Observation(BuilderImpl builder) {
        this.id = builder.id;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.sourceType = builder.sourceType;
        this.sourceARN = builder.sourceARN;
        this.logGroup = builder.logGroup;
        this.lineTime = builder.lineTime;
        this.logText = builder.logText;
        this.logFilter = builder.logFilter;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.unit = builder.unit;
        this.value = builder.value;
        this.cloudWatchEventId = builder.cloudWatchEventId;
        this.cloudWatchEventSource = builder.cloudWatchEventSource;
        this.cloudWatchEventDetailType = builder.cloudWatchEventDetailType;
        this.healthEventArn = builder.healthEventArn;
        this.healthService = builder.healthService;
        this.healthEventTypeCode = builder.healthEventTypeCode;
        this.healthEventTypeCategory = builder.healthEventTypeCategory;
        this.healthEventDescription = builder.healthEventDescription;
        this.codeDeployDeploymentId = builder.codeDeployDeploymentId;
        this.codeDeployDeploymentGroup = builder.codeDeployDeploymentGroup;
        this.codeDeployState = builder.codeDeployState;
        this.codeDeployApplication = builder.codeDeployApplication;
        this.codeDeployInstanceGroupId = builder.codeDeployInstanceGroupId;
        this.ec2State = builder.ec2State;
        this.xRayFaultPercent = builder.xRayFaultPercent;
        this.xRayThrottlePercent = builder.xRayThrottlePercent;
        this.xRayErrorPercent = builder.xRayErrorPercent;
        this.xRayRequestCount = builder.xRayRequestCount;
        this.xRayRequestAverageLatency = builder.xRayRequestAverageLatency;
        this.xRayNodeName = builder.xRayNodeName;
        this.xRayNodeType = builder.xRayNodeType;
    }

    public String id() {
        return this.id;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public String sourceARN() {
        return this.sourceARN;
    }

    public String logGroup() {
        return this.logGroup;
    }

    public Instant lineTime() {
        return this.lineTime;
    }

    public String logText() {
        return this.logText;
    }

    public LogFilter logFilter() {
        return LogFilter.fromValue(this.logFilter);
    }

    public String logFilterAsString() {
        return this.logFilter;
    }

    public String metricNamespace() {
        return this.metricNamespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public String unit() {
        return this.unit;
    }

    public Double value() {
        return this.value;
    }

    public String cloudWatchEventId() {
        return this.cloudWatchEventId;
    }

    public CloudWatchEventSource cloudWatchEventSource() {
        return CloudWatchEventSource.fromValue(this.cloudWatchEventSource);
    }

    public String cloudWatchEventSourceAsString() {
        return this.cloudWatchEventSource;
    }

    public String cloudWatchEventDetailType() {
        return this.cloudWatchEventDetailType;
    }

    public String healthEventArn() {
        return this.healthEventArn;
    }

    public String healthService() {
        return this.healthService;
    }

    public String healthEventTypeCode() {
        return this.healthEventTypeCode;
    }

    public String healthEventTypeCategory() {
        return this.healthEventTypeCategory;
    }

    public String healthEventDescription() {
        return this.healthEventDescription;
    }

    public String codeDeployDeploymentId() {
        return this.codeDeployDeploymentId;
    }

    public String codeDeployDeploymentGroup() {
        return this.codeDeployDeploymentGroup;
    }

    public String codeDeployState() {
        return this.codeDeployState;
    }

    public String codeDeployApplication() {
        return this.codeDeployApplication;
    }

    public String codeDeployInstanceGroupId() {
        return this.codeDeployInstanceGroupId;
    }

    public String ec2State() {
        return this.ec2State;
    }

    public Integer xRayFaultPercent() {
        return this.xRayFaultPercent;
    }

    public Integer xRayThrottlePercent() {
        return this.xRayThrottlePercent;
    }

    public Integer xRayErrorPercent() {
        return this.xRayErrorPercent;
    }

    public Integer xRayRequestCount() {
        return this.xRayRequestCount;
    }

    public Long xRayRequestAverageLatency() {
        return this.xRayRequestAverageLatency;
    }

    public String xRayNodeName() {
        return this.xRayNodeName;
    }

    public String xRayNodeType() {
        return this.xRayNodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logText());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEventSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchEventDetailType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthEventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthService());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthEventTypeCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthEventTypeCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthEventDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployDeploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployDeploymentGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployState());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployApplication());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeDeployInstanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2State());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayFaultPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayThrottlePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayErrorPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayRequestAverageLatency());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayNodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.xRayNodeType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Observation)) {
            return false;
        }
        Observation other = (Observation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.sourceARN(), other.sourceARN()) && Objects.equals(this.logGroup(), other.logGroup()) && Objects.equals(this.lineTime(), other.lineTime()) && Objects.equals(this.logText(), other.logText()) && Objects.equals(this.logFilterAsString(), other.logFilterAsString()) && Objects.equals(this.metricNamespace(), other.metricNamespace()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.unit(), other.unit()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.cloudWatchEventId(), other.cloudWatchEventId()) && Objects.equals(this.cloudWatchEventSourceAsString(), other.cloudWatchEventSourceAsString()) && Objects.equals(this.cloudWatchEventDetailType(), other.cloudWatchEventDetailType()) && Objects.equals(this.healthEventArn(), other.healthEventArn()) && Objects.equals(this.healthService(), other.healthService()) && Objects.equals(this.healthEventTypeCode(), other.healthEventTypeCode()) && Objects.equals(this.healthEventTypeCategory(), other.healthEventTypeCategory()) && Objects.equals(this.healthEventDescription(), other.healthEventDescription()) && Objects.equals(this.codeDeployDeploymentId(), other.codeDeployDeploymentId()) && Objects.equals(this.codeDeployDeploymentGroup(), other.codeDeployDeploymentGroup()) && Objects.equals(this.codeDeployState(), other.codeDeployState()) && Objects.equals(this.codeDeployApplication(), other.codeDeployApplication()) && Objects.equals(this.codeDeployInstanceGroupId(), other.codeDeployInstanceGroupId()) && Objects.equals(this.ec2State(), other.ec2State()) && Objects.equals(this.xRayFaultPercent(), other.xRayFaultPercent()) && Objects.equals(this.xRayThrottlePercent(), other.xRayThrottlePercent()) && Objects.equals(this.xRayErrorPercent(), other.xRayErrorPercent()) && Objects.equals(this.xRayRequestCount(), other.xRayRequestCount()) && Objects.equals(this.xRayRequestAverageLatency(), other.xRayRequestAverageLatency()) && Objects.equals(this.xRayNodeName(), other.xRayNodeName()) && Objects.equals(this.xRayNodeType(), other.xRayNodeType());
    }

    public String toString() {
        return ToString.builder((String)"Observation").add("Id", (Object)this.id()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("SourceType", (Object)this.sourceType()).add("SourceARN", (Object)this.sourceARN()).add("LogGroup", (Object)this.logGroup()).add("LineTime", (Object)this.lineTime()).add("LogText", (Object)this.logText()).add("LogFilter", (Object)this.logFilterAsString()).add("MetricNamespace", (Object)this.metricNamespace()).add("MetricName", (Object)this.metricName()).add("Unit", (Object)this.unit()).add("Value", (Object)this.value()).add("CloudWatchEventId", (Object)this.cloudWatchEventId()).add("CloudWatchEventSource", (Object)this.cloudWatchEventSourceAsString()).add("CloudWatchEventDetailType", (Object)this.cloudWatchEventDetailType()).add("HealthEventArn", (Object)this.healthEventArn()).add("HealthService", (Object)this.healthService()).add("HealthEventTypeCode", (Object)this.healthEventTypeCode()).add("HealthEventTypeCategory", (Object)this.healthEventTypeCategory()).add("HealthEventDescription", (Object)this.healthEventDescription()).add("CodeDeployDeploymentId", (Object)this.codeDeployDeploymentId()).add("CodeDeployDeploymentGroup", (Object)this.codeDeployDeploymentGroup()).add("CodeDeployState", (Object)this.codeDeployState()).add("CodeDeployApplication", (Object)this.codeDeployApplication()).add("CodeDeployInstanceGroupId", (Object)this.codeDeployInstanceGroupId()).add("Ec2State", (Object)this.ec2State()).add("XRayFaultPercent", (Object)this.xRayFaultPercent()).add("XRayThrottlePercent", (Object)this.xRayThrottlePercent()).add("XRayErrorPercent", (Object)this.xRayErrorPercent()).add("XRayRequestCount", (Object)this.xRayRequestCount()).add("XRayRequestAverageLatency", (Object)this.xRayRequestAverageLatency()).add("XRayNodeName", (Object)this.xRayNodeName()).add("XRayNodeType", (Object)this.xRayNodeType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "SourceARN": {
                return Optional.ofNullable(clazz.cast(this.sourceARN()));
            }
            case "LogGroup": {
                return Optional.ofNullable(clazz.cast(this.logGroup()));
            }
            case "LineTime": {
                return Optional.ofNullable(clazz.cast(this.lineTime()));
            }
            case "LogText": {
                return Optional.ofNullable(clazz.cast(this.logText()));
            }
            case "LogFilter": {
                return Optional.ofNullable(clazz.cast(this.logFilterAsString()));
            }
            case "MetricNamespace": {
                return Optional.ofNullable(clazz.cast(this.metricNamespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "CloudWatchEventId": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEventId()));
            }
            case "CloudWatchEventSource": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEventSourceAsString()));
            }
            case "CloudWatchEventDetailType": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchEventDetailType()));
            }
            case "HealthEventArn": {
                return Optional.ofNullable(clazz.cast(this.healthEventArn()));
            }
            case "HealthService": {
                return Optional.ofNullable(clazz.cast(this.healthService()));
            }
            case "HealthEventTypeCode": {
                return Optional.ofNullable(clazz.cast(this.healthEventTypeCode()));
            }
            case "HealthEventTypeCategory": {
                return Optional.ofNullable(clazz.cast(this.healthEventTypeCategory()));
            }
            case "HealthEventDescription": {
                return Optional.ofNullable(clazz.cast(this.healthEventDescription()));
            }
            case "CodeDeployDeploymentId": {
                return Optional.ofNullable(clazz.cast(this.codeDeployDeploymentId()));
            }
            case "CodeDeployDeploymentGroup": {
                return Optional.ofNullable(clazz.cast(this.codeDeployDeploymentGroup()));
            }
            case "CodeDeployState": {
                return Optional.ofNullable(clazz.cast(this.codeDeployState()));
            }
            case "CodeDeployApplication": {
                return Optional.ofNullable(clazz.cast(this.codeDeployApplication()));
            }
            case "CodeDeployInstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.codeDeployInstanceGroupId()));
            }
            case "Ec2State": {
                return Optional.ofNullable(clazz.cast(this.ec2State()));
            }
            case "XRayFaultPercent": {
                return Optional.ofNullable(clazz.cast(this.xRayFaultPercent()));
            }
            case "XRayThrottlePercent": {
                return Optional.ofNullable(clazz.cast(this.xRayThrottlePercent()));
            }
            case "XRayErrorPercent": {
                return Optional.ofNullable(clazz.cast(this.xRayErrorPercent()));
            }
            case "XRayRequestCount": {
                return Optional.ofNullable(clazz.cast(this.xRayRequestCount()));
            }
            case "XRayRequestAverageLatency": {
                return Optional.ofNullable(clazz.cast(this.xRayRequestAverageLatency()));
            }
            case "XRayNodeName": {
                return Optional.ofNullable(clazz.cast(this.xRayNodeName()));
            }
            case "XRayNodeType": {
                return Optional.ofNullable(clazz.cast(this.xRayNodeType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Observation, T> g) {
        return obj -> g.apply((Observation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant startTime;
        private Instant endTime;
        private String sourceType;
        private String sourceARN;
        private String logGroup;
        private Instant lineTime;
        private String logText;
        private String logFilter;
        private String metricNamespace;
        private String metricName;
        private String unit;
        private Double value;
        private String cloudWatchEventId;
        private String cloudWatchEventSource;
        private String cloudWatchEventDetailType;
        private String healthEventArn;
        private String healthService;
        private String healthEventTypeCode;
        private String healthEventTypeCategory;
        private String healthEventDescription;
        private String codeDeployDeploymentId;
        private String codeDeployDeploymentGroup;
        private String codeDeployState;
        private String codeDeployApplication;
        private String codeDeployInstanceGroupId;
        private String ec2State;
        private Integer xRayFaultPercent;
        private Integer xRayThrottlePercent;
        private Integer xRayErrorPercent;
        private Integer xRayRequestCount;
        private Long xRayRequestAverageLatency;
        private String xRayNodeName;
        private String xRayNodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Observation model) {
            this.id(model.id);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.sourceType(model.sourceType);
            this.sourceARN(model.sourceARN);
            this.logGroup(model.logGroup);
            this.lineTime(model.lineTime);
            this.logText(model.logText);
            this.logFilter(model.logFilter);
            this.metricNamespace(model.metricNamespace);
            this.metricName(model.metricName);
            this.unit(model.unit);
            this.value(model.value);
            this.cloudWatchEventId(model.cloudWatchEventId);
            this.cloudWatchEventSource(model.cloudWatchEventSource);
            this.cloudWatchEventDetailType(model.cloudWatchEventDetailType);
            this.healthEventArn(model.healthEventArn);
            this.healthService(model.healthService);
            this.healthEventTypeCode(model.healthEventTypeCode);
            this.healthEventTypeCategory(model.healthEventTypeCategory);
            this.healthEventDescription(model.healthEventDescription);
            this.codeDeployDeploymentId(model.codeDeployDeploymentId);
            this.codeDeployDeploymentGroup(model.codeDeployDeploymentGroup);
            this.codeDeployState(model.codeDeployState);
            this.codeDeployApplication(model.codeDeployApplication);
            this.codeDeployInstanceGroupId(model.codeDeployInstanceGroupId);
            this.ec2State(model.ec2State);
            this.xRayFaultPercent(model.xRayFaultPercent);
            this.xRayThrottlePercent(model.xRayThrottlePercent);
            this.xRayErrorPercent(model.xRayErrorPercent);
            this.xRayRequestCount(model.xRayRequestCount);
            this.xRayRequestAverageLatency(model.xRayRequestAverageLatency);
            this.xRayNodeName(model.xRayNodeName);
            this.xRayNodeType(model.xRayNodeType);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getSourceARN() {
            return this.sourceARN;
        }

        @Override
        public final Builder sourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
            return this;
        }

        public final void setSourceARN(String sourceARN) {
            this.sourceARN = sourceARN;
        }

        public final String getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        public final Instant getLineTime() {
            return this.lineTime;
        }

        @Override
        public final Builder lineTime(Instant lineTime) {
            this.lineTime = lineTime;
            return this;
        }

        public final void setLineTime(Instant lineTime) {
            this.lineTime = lineTime;
        }

        public final String getLogText() {
            return this.logText;
        }

        @Override
        public final Builder logText(String logText) {
            this.logText = logText;
            return this;
        }

        public final void setLogText(String logText) {
            this.logText = logText;
        }

        public final String getLogFilter() {
            return this.logFilter;
        }

        @Override
        public final Builder logFilter(String logFilter) {
            this.logFilter = logFilter;
            return this;
        }

        @Override
        public final Builder logFilter(LogFilter logFilter) {
            this.logFilter(logFilter == null ? null : logFilter.toString());
            return this;
        }

        public final void setLogFilter(String logFilter) {
            this.logFilter = logFilter;
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final String getCloudWatchEventId() {
            return this.cloudWatchEventId;
        }

        @Override
        public final Builder cloudWatchEventId(String cloudWatchEventId) {
            this.cloudWatchEventId = cloudWatchEventId;
            return this;
        }

        public final void setCloudWatchEventId(String cloudWatchEventId) {
            this.cloudWatchEventId = cloudWatchEventId;
        }

        public final String getCloudWatchEventSource() {
            return this.cloudWatchEventSource;
        }

        @Override
        public final Builder cloudWatchEventSource(String cloudWatchEventSource) {
            this.cloudWatchEventSource = cloudWatchEventSource;
            return this;
        }

        @Override
        public final Builder cloudWatchEventSource(CloudWatchEventSource cloudWatchEventSource) {
            this.cloudWatchEventSource(cloudWatchEventSource == null ? null : cloudWatchEventSource.toString());
            return this;
        }

        public final void setCloudWatchEventSource(String cloudWatchEventSource) {
            this.cloudWatchEventSource = cloudWatchEventSource;
        }

        public final String getCloudWatchEventDetailType() {
            return this.cloudWatchEventDetailType;
        }

        @Override
        public final Builder cloudWatchEventDetailType(String cloudWatchEventDetailType) {
            this.cloudWatchEventDetailType = cloudWatchEventDetailType;
            return this;
        }

        public final void setCloudWatchEventDetailType(String cloudWatchEventDetailType) {
            this.cloudWatchEventDetailType = cloudWatchEventDetailType;
        }

        public final String getHealthEventArn() {
            return this.healthEventArn;
        }

        @Override
        public final Builder healthEventArn(String healthEventArn) {
            this.healthEventArn = healthEventArn;
            return this;
        }

        public final void setHealthEventArn(String healthEventArn) {
            this.healthEventArn = healthEventArn;
        }

        public final String getHealthService() {
            return this.healthService;
        }

        @Override
        public final Builder healthService(String healthService) {
            this.healthService = healthService;
            return this;
        }

        public final void setHealthService(String healthService) {
            this.healthService = healthService;
        }

        public final String getHealthEventTypeCode() {
            return this.healthEventTypeCode;
        }

        @Override
        public final Builder healthEventTypeCode(String healthEventTypeCode) {
            this.healthEventTypeCode = healthEventTypeCode;
            return this;
        }

        public final void setHealthEventTypeCode(String healthEventTypeCode) {
            this.healthEventTypeCode = healthEventTypeCode;
        }

        public final String getHealthEventTypeCategory() {
            return this.healthEventTypeCategory;
        }

        @Override
        public final Builder healthEventTypeCategory(String healthEventTypeCategory) {
            this.healthEventTypeCategory = healthEventTypeCategory;
            return this;
        }

        public final void setHealthEventTypeCategory(String healthEventTypeCategory) {
            this.healthEventTypeCategory = healthEventTypeCategory;
        }

        public final String getHealthEventDescription() {
            return this.healthEventDescription;
        }

        @Override
        public final Builder healthEventDescription(String healthEventDescription) {
            this.healthEventDescription = healthEventDescription;
            return this;
        }

        public final void setHealthEventDescription(String healthEventDescription) {
            this.healthEventDescription = healthEventDescription;
        }

        public final String getCodeDeployDeploymentId() {
            return this.codeDeployDeploymentId;
        }

        @Override
        public final Builder codeDeployDeploymentId(String codeDeployDeploymentId) {
            this.codeDeployDeploymentId = codeDeployDeploymentId;
            return this;
        }

        public final void setCodeDeployDeploymentId(String codeDeployDeploymentId) {
            this.codeDeployDeploymentId = codeDeployDeploymentId;
        }

        public final String getCodeDeployDeploymentGroup() {
            return this.codeDeployDeploymentGroup;
        }

        @Override
        public final Builder codeDeployDeploymentGroup(String codeDeployDeploymentGroup) {
            this.codeDeployDeploymentGroup = codeDeployDeploymentGroup;
            return this;
        }

        public final void setCodeDeployDeploymentGroup(String codeDeployDeploymentGroup) {
            this.codeDeployDeploymentGroup = codeDeployDeploymentGroup;
        }

        public final String getCodeDeployState() {
            return this.codeDeployState;
        }

        @Override
        public final Builder codeDeployState(String codeDeployState) {
            this.codeDeployState = codeDeployState;
            return this;
        }

        public final void setCodeDeployState(String codeDeployState) {
            this.codeDeployState = codeDeployState;
        }

        public final String getCodeDeployApplication() {
            return this.codeDeployApplication;
        }

        @Override
        public final Builder codeDeployApplication(String codeDeployApplication) {
            this.codeDeployApplication = codeDeployApplication;
            return this;
        }

        public final void setCodeDeployApplication(String codeDeployApplication) {
            this.codeDeployApplication = codeDeployApplication;
        }

        public final String getCodeDeployInstanceGroupId() {
            return this.codeDeployInstanceGroupId;
        }

        @Override
        public final Builder codeDeployInstanceGroupId(String codeDeployInstanceGroupId) {
            this.codeDeployInstanceGroupId = codeDeployInstanceGroupId;
            return this;
        }

        public final void setCodeDeployInstanceGroupId(String codeDeployInstanceGroupId) {
            this.codeDeployInstanceGroupId = codeDeployInstanceGroupId;
        }

        public final String getEc2State() {
            return this.ec2State;
        }

        @Override
        public final Builder ec2State(String ec2State) {
            this.ec2State = ec2State;
            return this;
        }

        public final void setEc2State(String ec2State) {
            this.ec2State = ec2State;
        }

        public final Integer getXRayFaultPercent() {
            return this.xRayFaultPercent;
        }

        @Override
        public final Builder xRayFaultPercent(Integer xRayFaultPercent) {
            this.xRayFaultPercent = xRayFaultPercent;
            return this;
        }

        public final void setXRayFaultPercent(Integer xRayFaultPercent) {
            this.xRayFaultPercent = xRayFaultPercent;
        }

        public final Integer getXRayThrottlePercent() {
            return this.xRayThrottlePercent;
        }

        @Override
        public final Builder xRayThrottlePercent(Integer xRayThrottlePercent) {
            this.xRayThrottlePercent = xRayThrottlePercent;
            return this;
        }

        public final void setXRayThrottlePercent(Integer xRayThrottlePercent) {
            this.xRayThrottlePercent = xRayThrottlePercent;
        }

        public final Integer getXRayErrorPercent() {
            return this.xRayErrorPercent;
        }

        @Override
        public final Builder xRayErrorPercent(Integer xRayErrorPercent) {
            this.xRayErrorPercent = xRayErrorPercent;
            return this;
        }

        public final void setXRayErrorPercent(Integer xRayErrorPercent) {
            this.xRayErrorPercent = xRayErrorPercent;
        }

        public final Integer getXRayRequestCount() {
            return this.xRayRequestCount;
        }

        @Override
        public final Builder xRayRequestCount(Integer xRayRequestCount) {
            this.xRayRequestCount = xRayRequestCount;
            return this;
        }

        public final void setXRayRequestCount(Integer xRayRequestCount) {
            this.xRayRequestCount = xRayRequestCount;
        }

        public final Long getXRayRequestAverageLatency() {
            return this.xRayRequestAverageLatency;
        }

        @Override
        public final Builder xRayRequestAverageLatency(Long xRayRequestAverageLatency) {
            this.xRayRequestAverageLatency = xRayRequestAverageLatency;
            return this;
        }

        public final void setXRayRequestAverageLatency(Long xRayRequestAverageLatency) {
            this.xRayRequestAverageLatency = xRayRequestAverageLatency;
        }

        public final String getXRayNodeName() {
            return this.xRayNodeName;
        }

        @Override
        public final Builder xRayNodeName(String xRayNodeName) {
            this.xRayNodeName = xRayNodeName;
            return this;
        }

        public final void setXRayNodeName(String xRayNodeName) {
            this.xRayNodeName = xRayNodeName;
        }

        public final String getXRayNodeType() {
            return this.xRayNodeType;
        }

        @Override
        public final Builder xRayNodeType(String xRayNodeType) {
            this.xRayNodeType = xRayNodeType;
            return this;
        }

        public final void setXRayNodeType(String xRayNodeType) {
            this.xRayNodeType = xRayNodeType;
        }

        public Observation build() {
            return new Observation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Observation> {
        public Builder id(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder sourceType(String var1);

        public Builder sourceARN(String var1);

        public Builder logGroup(String var1);

        public Builder lineTime(Instant var1);

        public Builder logText(String var1);

        public Builder logFilter(String var1);

        public Builder logFilter(LogFilter var1);

        public Builder metricNamespace(String var1);

        public Builder metricName(String var1);

        public Builder unit(String var1);

        public Builder value(Double var1);

        public Builder cloudWatchEventId(String var1);

        public Builder cloudWatchEventSource(String var1);

        public Builder cloudWatchEventSource(CloudWatchEventSource var1);

        public Builder cloudWatchEventDetailType(String var1);

        public Builder healthEventArn(String var1);

        public Builder healthService(String var1);

        public Builder healthEventTypeCode(String var1);

        public Builder healthEventTypeCategory(String var1);

        public Builder healthEventDescription(String var1);

        public Builder codeDeployDeploymentId(String var1);

        public Builder codeDeployDeploymentGroup(String var1);

        public Builder codeDeployState(String var1);

        public Builder codeDeployApplication(String var1);

        public Builder codeDeployInstanceGroupId(String var1);

        public Builder ec2State(String var1);

        public Builder xRayFaultPercent(Integer var1);

        public Builder xRayThrottlePercent(Integer var1);

        public Builder xRayErrorPercent(Integer var1);

        public Builder xRayRequestCount(Integer var1);

        public Builder xRayRequestAverageLatency(Long var1);

        public Builder xRayNodeName(String var1);

        public Builder xRayNodeType(String var1);
    }
}

