/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SeverityLevel {
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SeverityLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SeverityLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SeverityLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SeverityLevel> knownValues() {
        return Stream.of(SeverityLevel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

