/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLogPatternSetsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListLogPatternSetsResponse.Builder, ListLogPatternSetsResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(ListLogPatternSetsResponse::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<List<String>> LOG_PATTERN_SETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogPatternSets")
            .getter(getter(ListLogPatternSetsResponse::logPatternSets))
            .setter(setter(Builder::logPatternSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPatternSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLogPatternSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            LOG_PATTERN_SETS_FIELD, NEXT_TOKEN_FIELD));

    private final String resourceGroupName;

    private final List<String> logPatternSets;

    private final String nextToken;

    private ListLogPatternSetsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.logPatternSets = builder.logPatternSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogPatternSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogPatternSets() {
        return logPatternSets != null && !(logPatternSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log pattern sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPatternSets} method.
     * </p>
     * 
     * @return The list of log pattern sets.
     */
    public final List<String> logPatternSets() {
        return logPatternSets;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogPatternSets() ? logPatternSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogPatternSetsResponse)) {
            return false;
        }
        ListLogPatternSetsResponse other = (ListLogPatternSetsResponse) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName()) && hasLogPatternSets() == other.hasLogPatternSets()
                && Objects.equals(logPatternSets(), other.logPatternSets()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLogPatternSetsResponse").add("ResourceGroupName", resourceGroupName())
                .add("LogPatternSets", hasLogPatternSets() ? logPatternSets() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "LogPatternSets":
            return Optional.ofNullable(clazz.cast(logPatternSets()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLogPatternSetsResponse, T> g) {
        return obj -> g.apply((ListLogPatternSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLogPatternSetsResponse> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The list of log pattern sets.
         * </p>
         * 
         * @param logPatternSets
         *        The list of log pattern sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatternSets(Collection<String> logPatternSets);

        /**
         * <p>
         * The list of log pattern sets.
         * </p>
         * 
         * @param logPatternSets
         *        The list of log pattern sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatternSets(String... logPatternSets);

        /**
         * <p>
         * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String resourceGroupName;

        private List<String> logPatternSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogPatternSetsResponse model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            logPatternSets(model.logPatternSets);
            nextToken(model.nextToken);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        @Transient
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final Collection<String> getLogPatternSets() {
            if (logPatternSets instanceof SdkAutoConstructList) {
                return null;
            }
            return logPatternSets;
        }

        public final void setLogPatternSets(Collection<String> logPatternSets) {
            this.logPatternSets = LogPatternSetListCopier.copy(logPatternSets);
        }

        @Override
        @Transient
        public final Builder logPatternSets(Collection<String> logPatternSets) {
            this.logPatternSets = LogPatternSetListCopier.copy(logPatternSets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder logPatternSets(String... logPatternSets) {
            logPatternSets(Arrays.asList(logPatternSets));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLogPatternSetsResponse build() {
            return new ListLogPatternSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
