/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.Observation;
import software.amazon.awssdk.services.applicationinsights.model.ObservationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedObservations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedObservations> {
    private static final SdkField<List<Observation>> OBSERVATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObservationList").getter(RelatedObservations.getter(RelatedObservations::observationList)).setter(RelatedObservations.setter(Builder::observationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Observation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVATION_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Observation> observationList;

    private RelatedObservations(BuilderImpl builder) {
        this.observationList = builder.observationList;
    }

    public final boolean hasObservationList() {
        return this.observationList != null && !(this.observationList instanceof SdkAutoConstructList);
    }

    public final List<Observation> observationList() {
        return this.observationList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObservationList() ? this.observationList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedObservations)) {
            return false;
        }
        RelatedObservations other = (RelatedObservations)obj;
        return this.hasObservationList() == other.hasObservationList() && Objects.equals(this.observationList(), other.observationList());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedObservations").add("ObservationList", this.hasObservationList() ? this.observationList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObservationList": {
                return Optional.ofNullable(clazz.cast(this.observationList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedObservations, T> g) {
        return obj -> g.apply((RelatedObservations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Observation> observationList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedObservations model) {
            this.observationList(model.observationList);
        }

        public final List<Observation.Builder> getObservationList() {
            List<Observation.Builder> result = ObservationListCopier.copyToBuilder(this.observationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObservationList(Collection<Observation.BuilderImpl> observationList) {
            this.observationList = ObservationListCopier.copyFromBuilder(observationList);
        }

        @Override
        @Transient
        public final Builder observationList(Collection<Observation> observationList) {
            this.observationList = ObservationListCopier.copy(observationList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder observationList(Observation ... observationList) {
            this.observationList(Arrays.asList(observationList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder observationList(Consumer<Observation.Builder> ... observationList) {
            this.observationList(Stream.of(observationList).map(c -> (Observation)((Observation.Builder)Observation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RelatedObservations build() {
            return new RelatedObservations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedObservations> {
        public Builder observationList(Collection<Observation> var1);

        public Builder observationList(Observation ... var1);

        public Builder observationList(Consumer<Observation.Builder> ... var1);
    }
}

