/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationInfo implements SdkPojo, Serializable, ToCopyableBuilder<ApplicationInfo.Builder, ApplicationInfo> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(ApplicationInfo::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> LIFE_CYCLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifeCycle").getter(getter(ApplicationInfo::lifeCycle)).setter(setter(Builder::lifeCycle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()).build();

    private static final SdkField<String> OPS_ITEM_SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemSNSTopicArn").getter(getter(ApplicationInfo::opsItemSNSTopicArn))
            .setter(setter(Builder::opsItemSNSTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemSNSTopicArn").build())
            .build();

    private static final SdkField<Boolean> OPS_CENTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OpsCenterEnabled").getter(getter(ApplicationInfo::opsCenterEnabled))
            .setter(setter(Builder::opsCenterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsCenterEnabled").build()).build();

    private static final SdkField<Boolean> CWE_MONITOR_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CWEMonitorEnabled").getter(getter(ApplicationInfo::cweMonitorEnabled))
            .setter(setter(Builder::cweMonitorEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CWEMonitorEnabled").build()).build();

    private static final SdkField<String> REMARKS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Remarks")
            .getter(getter(ApplicationInfo::remarks)).setter(setter(Builder::remarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Remarks").build()).build();

    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoConfigEnabled").getter(getter(ApplicationInfo::autoConfigEnabled))
            .setter(setter(Builder::autoConfigEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()).build();

    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DiscoveryType").getter(getter(ApplicationInfo::discoveryTypeAsString))
            .setter(setter(Builder::discoveryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            LIFE_CYCLE_FIELD, OPS_ITEM_SNS_TOPIC_ARN_FIELD, OPS_CENTER_ENABLED_FIELD, CWE_MONITOR_ENABLED_FIELD, REMARKS_FIELD,
            AUTO_CONFIG_ENABLED_FIELD, DISCOVERY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceGroupName;

    private final String lifeCycle;

    private final String opsItemSNSTopicArn;

    private final Boolean opsCenterEnabled;

    private final Boolean cweMonitorEnabled;

    private final String remarks;

    private final Boolean autoConfigEnabled;

    private final String discoveryType;

    private ApplicationInfo(BuilderImpl builder) {
        this.resourceGroupName = builder.resourceGroupName;
        this.lifeCycle = builder.lifeCycle;
        this.opsItemSNSTopicArn = builder.opsItemSNSTopicArn;
        this.opsCenterEnabled = builder.opsCenterEnabled;
        this.cweMonitorEnabled = builder.cweMonitorEnabled;
        this.remarks = builder.remarks;
        this.autoConfigEnabled = builder.autoConfigEnabled;
        this.discoveryType = builder.discoveryType;
    }

    /**
     * <p>
     * The name of the resource group used for the application.
     * </p>
     * 
     * @return The name of the resource group used for the application.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The lifecycle of the application.
     * </p>
     * 
     * @return The lifecycle of the application.
     */
    public final String lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS
     * notifications for opsItem updates.
     * </p>
     * 
     * @return The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS
     *         notifications for opsItem updates.
     */
    public final String opsItemSNSTopicArn() {
        return opsItemSNSTopicArn;
    }

    /**
     * <p>
     * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights for
     * an application.
     * </p>
     * 
     * @return Indicates whether Application Insights will create opsItems for any problem detected by Application
     *         Insights for an application.
     */
    public final Boolean opsCenterEnabled() {
        return opsCenterEnabled;
    }

    /**
     * <p>
     * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
     * <code>instance terminated</code>, <code>failed deployment</code>, and others.
     * </p>
     * 
     * @return Indicates whether Application Insights can listen to CloudWatch events for the application resources,
     *         such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
     */
    public final Boolean cweMonitorEnabled() {
        return cweMonitorEnabled;
    }

    /**
     * <p>
     * The issues on the user side that block Application Insights from successfully monitoring an application. Example
     * remarks include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * “Configuring application, detected 1 Errors, 3 Warnings”
     * </p>
     * </li>
     * <li>
     * <p>
     * “Configuring application, detected 1 Unconfigured Components”
     * </p>
     * </li>
     * </ul>
     * 
     * @return The issues on the user side that block Application Insights from successfully monitoring an application.
     *         Example remarks include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         “Configuring application, detected 1 Errors, 3 Warnings”
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         “Configuring application, detected 1 Unconfigured Components”
     *         </p>
     *         </li>
     */
    public final String remarks() {
        return remarks;
    }

    /**
     * Returns the value of the AutoConfigEnabled property for this object.
     * 
     * @return The value of the AutoConfigEnabled property for this object.
     */
    public final Boolean autoConfigEnabled() {
        return autoConfigEnabled;
    }

    /**
     * Returns the value of the DiscoveryType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The value of the DiscoveryType property for this object.
     * @see DiscoveryType
     */
    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(discoveryType);
    }

    /**
     * Returns the value of the DiscoveryType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #discoveryType}
     * will return {@link DiscoveryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #discoveryTypeAsString}.
     * </p>
     * 
     * @return The value of the DiscoveryType property for this object.
     * @see DiscoveryType
     */
    public final String discoveryTypeAsString() {
        return discoveryType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(opsItemSNSTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(opsCenterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cweMonitorEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(remarks());
        hashCode = 31 * hashCode + Objects.hashCode(autoConfigEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationInfo)) {
            return false;
        }
        ApplicationInfo other = (ApplicationInfo) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName()) && Objects.equals(lifeCycle(), other.lifeCycle())
                && Objects.equals(opsItemSNSTopicArn(), other.opsItemSNSTopicArn())
                && Objects.equals(opsCenterEnabled(), other.opsCenterEnabled())
                && Objects.equals(cweMonitorEnabled(), other.cweMonitorEnabled()) && Objects.equals(remarks(), other.remarks())
                && Objects.equals(autoConfigEnabled(), other.autoConfigEnabled())
                && Objects.equals(discoveryTypeAsString(), other.discoveryTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationInfo").add("ResourceGroupName", resourceGroupName()).add("LifeCycle", lifeCycle())
                .add("OpsItemSNSTopicArn", opsItemSNSTopicArn()).add("OpsCenterEnabled", opsCenterEnabled())
                .add("CWEMonitorEnabled", cweMonitorEnabled()).add("Remarks", remarks())
                .add("AutoConfigEnabled", autoConfigEnabled()).add("DiscoveryType", discoveryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "LifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "OpsItemSNSTopicArn":
            return Optional.ofNullable(clazz.cast(opsItemSNSTopicArn()));
        case "OpsCenterEnabled":
            return Optional.ofNullable(clazz.cast(opsCenterEnabled()));
        case "CWEMonitorEnabled":
            return Optional.ofNullable(clazz.cast(cweMonitorEnabled()));
        case "Remarks":
            return Optional.ofNullable(clazz.cast(remarks()));
        case "AutoConfigEnabled":
            return Optional.ofNullable(clazz.cast(autoConfigEnabled()));
        case "DiscoveryType":
            return Optional.ofNullable(clazz.cast(discoveryTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationInfo, T> g) {
        return obj -> g.apply((ApplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationInfo> {
        /**
         * <p>
         * The name of the resource group used for the application.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group used for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The lifecycle of the application.
         * </p>
         * 
         * @param lifeCycle
         *        The lifecycle of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(String lifeCycle);

        /**
         * <p>
         * The SNS topic provided to Application Insights that is associated to the created opsItems to receive SNS
         * notifications for opsItem updates.
         * </p>
         * 
         * @param opsItemSNSTopicArn
         *        The SNS topic provided to Application Insights that is associated to the created opsItems to receive
         *        SNS notifications for opsItem updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemSNSTopicArn(String opsItemSNSTopicArn);

        /**
         * <p>
         * Indicates whether Application Insights will create opsItems for any problem detected by Application Insights
         * for an application.
         * </p>
         * 
         * @param opsCenterEnabled
         *        Indicates whether Application Insights will create opsItems for any problem detected by Application
         *        Insights for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsCenterEnabled(Boolean opsCenterEnabled);

        /**
         * <p>
         * Indicates whether Application Insights can listen to CloudWatch events for the application resources, such as
         * <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * </p>
         * 
         * @param cweMonitorEnabled
         *        Indicates whether Application Insights can listen to CloudWatch events for the application resources,
         *        such as <code>instance terminated</code>, <code>failed deployment</code>, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cweMonitorEnabled(Boolean cweMonitorEnabled);

        /**
         * <p>
         * The issues on the user side that block Application Insights from successfully monitoring an application.
         * Example remarks include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * “Configuring application, detected 1 Errors, 3 Warnings”
         * </p>
         * </li>
         * <li>
         * <p>
         * “Configuring application, detected 1 Unconfigured Components”
         * </p>
         * </li>
         * </ul>
         * 
         * @param remarks
         *        The issues on the user side that block Application Insights from successfully monitoring an
         *        application. Example remarks include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        “Configuring application, detected 1 Errors, 3 Warnings”
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        “Configuring application, detected 1 Unconfigured Components”
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remarks(String remarks);

        /**
         * Sets the value of the AutoConfigEnabled property for this object.
         *
         * @param autoConfigEnabled
         *        The new value for the AutoConfigEnabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoConfigEnabled(Boolean autoConfigEnabled);

        /**
         * Sets the value of the DiscoveryType property for this object.
         *
         * @param discoveryType
         *        The new value for the DiscoveryType property for this object.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(String discoveryType);

        /**
         * Sets the value of the DiscoveryType property for this object.
         *
         * @param discoveryType
         *        The new value for the DiscoveryType property for this object.
         * @see DiscoveryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiscoveryType
         */
        Builder discoveryType(DiscoveryType discoveryType);
    }

    static final class BuilderImpl implements Builder {
        private String resourceGroupName;

        private String lifeCycle;

        private String opsItemSNSTopicArn;

        private Boolean opsCenterEnabled;

        private Boolean cweMonitorEnabled;

        private String remarks;

        private Boolean autoConfigEnabled;

        private String discoveryType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationInfo model) {
            resourceGroupName(model.resourceGroupName);
            lifeCycle(model.lifeCycle);
            opsItemSNSTopicArn(model.opsItemSNSTopicArn);
            opsCenterEnabled(model.opsCenterEnabled);
            cweMonitorEnabled(model.cweMonitorEnabled);
            remarks(model.remarks);
            autoConfigEnabled(model.autoConfigEnabled);
            discoveryType(model.discoveryType);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getLifeCycle() {
            return lifeCycle;
        }

        public final void setLifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
        }

        @Override
        public final Builder lifeCycle(String lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getOpsItemSNSTopicArn() {
            return opsItemSNSTopicArn;
        }

        public final void setOpsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
        }

        @Override
        public final Builder opsItemSNSTopicArn(String opsItemSNSTopicArn) {
            this.opsItemSNSTopicArn = opsItemSNSTopicArn;
            return this;
        }

        public final Boolean getOpsCenterEnabled() {
            return opsCenterEnabled;
        }

        public final void setOpsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
        }

        @Override
        public final Builder opsCenterEnabled(Boolean opsCenterEnabled) {
            this.opsCenterEnabled = opsCenterEnabled;
            return this;
        }

        public final Boolean getCweMonitorEnabled() {
            return cweMonitorEnabled;
        }

        public final void setCweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
        }

        @Override
        public final Builder cweMonitorEnabled(Boolean cweMonitorEnabled) {
            this.cweMonitorEnabled = cweMonitorEnabled;
            return this;
        }

        public final String getRemarks() {
            return remarks;
        }

        public final void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        @Override
        public final Builder remarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        public final String getDiscoveryType() {
            return discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        @Override
        public ApplicationInfo build() {
            return new ApplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
