/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeApplicationResponse.Builder, DescribeApplicationResponse> {
    private static final SdkField<ApplicationInfo> APPLICATION_INFO_FIELD = SdkField
            .<ApplicationInfo> builder(MarshallingType.SDK_POJO).memberName("ApplicationInfo")
            .getter(getter(DescribeApplicationResponse::applicationInfo)).setter(setter(Builder::applicationInfo))
            .constructor(ApplicationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INFO_FIELD));

    private final ApplicationInfo applicationInfo;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInfo = builder.applicationInfo;
    }

    /**
     * <p>
     * Information about the application.
     * </p>
     * 
     * @return Information about the application.
     */
    public final ApplicationInfo applicationInfo() {
        return applicationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse) obj;
        return Objects.equals(applicationInfo(), other.applicationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationResponse").add("ApplicationInfo", applicationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInfo":
            return Optional.ofNullable(clazz.cast(applicationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeApplicationResponse> {
        /**
         * <p>
         * Information about the application.
         * </p>
         * 
         * @param applicationInfo
         *        Information about the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInfo(ApplicationInfo applicationInfo);

        /**
         * <p>
         * Information about the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApplicationInfo.Builder} avoiding the
         * need to create one manually via {@link ApplicationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationInfo(ApplicationInfo)}.
         * 
         * @param applicationInfo
         *        a consumer that will call methods on {@link ApplicationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationInfo(ApplicationInfo)
         */
        default Builder applicationInfo(Consumer<ApplicationInfo.Builder> applicationInfo) {
            return applicationInfo(ApplicationInfo.builder().applyMutation(applicationInfo).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private ApplicationInfo applicationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            super(model);
            applicationInfo(model.applicationInfo);
        }

        public final ApplicationInfo.Builder getApplicationInfo() {
            return applicationInfo != null ? applicationInfo.toBuilder() : null;
        }

        public final void setApplicationInfo(ApplicationInfo.BuilderImpl applicationInfo) {
            this.applicationInfo = applicationInfo != null ? applicationInfo.build() : null;
        }

        @Override
        public final Builder applicationInfo(ApplicationInfo applicationInfo) {
            this.applicationInfo = applicationInfo;
            return this;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
