/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationInfo>> APPLICATION_INFO_LIST_FIELD = SdkField
            .<List<ApplicationInfo>> builder(MarshallingType.LIST)
            .memberName("ApplicationInfoList")
            .getter(getter(ListApplicationsResponse::applicationInfoList))
            .setter(setter(Builder::applicationInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListApplicationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INFO_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApplicationInfo> applicationInfoList;

    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInfoList = builder.applicationInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationInfoList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationInfoList() {
        return applicationInfoList != null && !(applicationInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationInfoList} method.
     * </p>
     * 
     * @return The list of applications.
     */
    public final List<ApplicationInfo> applicationInfoList() {
        return applicationInfoList;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationInfoList() ? applicationInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        return hasApplicationInfoList() == other.hasApplicationInfoList()
                && Objects.equals(applicationInfoList(), other.applicationInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationsResponse")
                .add("ApplicationInfoList", hasApplicationInfoList() ? applicationInfoList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationInfoList":
            return Optional.ofNullable(clazz.cast(applicationInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * The list of applications.
         * </p>
         * 
         * @param applicationInfoList
         *        The list of applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInfoList(Collection<ApplicationInfo> applicationInfoList);

        /**
         * <p>
         * The list of applications.
         * </p>
         * 
         * @param applicationInfoList
         *        The list of applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationInfoList(ApplicationInfo... applicationInfoList);

        /**
         * <p>
         * The list of applications.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ApplicationInfo>.Builder} avoiding
         * the need to create one manually via {@link List<ApplicationInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationInfo>.Builder#build()} is called immediately and
         * its result is passed to {@link #applicationInfoList(List<ApplicationInfo>)}.
         * 
         * @param applicationInfoList
         *        a consumer that will call methods on {@link List<ApplicationInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationInfoList(List<ApplicationInfo>)
         */
        Builder applicationInfoList(Consumer<ApplicationInfo.Builder>... applicationInfoList);

        /**
         * <p>
         * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private List<ApplicationInfo> applicationInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            applicationInfoList(model.applicationInfoList);
            nextToken(model.nextToken);
        }

        public final List<ApplicationInfo.Builder> getApplicationInfoList() {
            List<ApplicationInfo.Builder> result = ApplicationInfoListCopier.copyToBuilder(this.applicationInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationInfoList(Collection<ApplicationInfo.BuilderImpl> applicationInfoList) {
            this.applicationInfoList = ApplicationInfoListCopier.copyFromBuilder(applicationInfoList);
        }

        @Override
        public final Builder applicationInfoList(Collection<ApplicationInfo> applicationInfoList) {
            this.applicationInfoList = ApplicationInfoListCopier.copy(applicationInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInfoList(ApplicationInfo... applicationInfoList) {
            applicationInfoList(Arrays.asList(applicationInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInfoList(Consumer<ApplicationInfo.Builder>... applicationInfoList) {
            applicationInfoList(Stream.of(applicationInfoList).map(c -> ApplicationInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
