/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLogPatternResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<UpdateLogPatternResponse.Builder, UpdateLogPatternResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(UpdateLogPatternResponse::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<LogPattern> LOG_PATTERN_FIELD = SdkField.<LogPattern> builder(MarshallingType.SDK_POJO)
            .memberName("LogPattern").getter(getter(UpdateLogPatternResponse::logPattern)).setter(setter(Builder::logPattern))
            .constructor(LogPattern::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            LOG_PATTERN_FIELD));

    private final String resourceGroupName;

    private final LogPattern logPattern;

    private UpdateLogPatternResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.logPattern = builder.logPattern;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The successfully created log pattern.
     * </p>
     * 
     * @return The successfully created log pattern.
     */
    public final LogPattern logPattern() {
        return logPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(logPattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogPatternResponse)) {
            return false;
        }
        UpdateLogPatternResponse other = (UpdateLogPatternResponse) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName()) && Objects.equals(logPattern(), other.logPattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLogPatternResponse").add("ResourceGroupName", resourceGroupName())
                .add("LogPattern", logPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "LogPattern":
            return Optional.ofNullable(clazz.cast(logPattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogPatternResponse, T> g) {
        return obj -> g.apply((UpdateLogPatternResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateLogPatternResponse> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The successfully created log pattern.
         * </p>
         * 
         * @param logPattern
         *        The successfully created log pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPattern(LogPattern logPattern);

        /**
         * <p>
         * The successfully created log pattern.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogPattern.Builder} avoiding the need to
         * create one manually via {@link LogPattern#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogPattern.Builder#build()} is called immediately and its result
         * is passed to {@link #logPattern(LogPattern)}.
         * 
         * @param logPattern
         *        a consumer that will call methods on {@link LogPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPattern(LogPattern)
         */
        default Builder logPattern(Consumer<LogPattern.Builder> logPattern) {
            return logPattern(LogPattern.builder().applyMutation(logPattern).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String resourceGroupName;

        private LogPattern logPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogPatternResponse model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            logPattern(model.logPattern);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final LogPattern.Builder getLogPattern() {
            return logPattern != null ? logPattern.toBuilder() : null;
        }

        public final void setLogPattern(LogPattern.BuilderImpl logPattern) {
            this.logPattern = logPattern != null ? logPattern.build() : null;
        }

        @Override
        public final Builder logPattern(LogPattern logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        @Override
        public UpdateLogPatternResponse build() {
            return new UpdateLogPatternResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
