/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.LogPattern;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogPatternResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, DescribeLogPatternResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(DescribeLogPatternResponse.getter(DescribeLogPatternResponse::resourceGroupName)).setter(DescribeLogPatternResponse.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<LogPattern> LOG_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogPattern").getter(DescribeLogPatternResponse.getter(DescribeLogPatternResponse::logPattern)).setter(DescribeLogPatternResponse.setter(Builder::logPattern)).constructor(LogPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, LOG_PATTERN_FIELD));
    private final String resourceGroupName;
    private final LogPattern logPattern;

    private DescribeLogPatternResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.logPattern = builder.logPattern;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final LogPattern logPattern() {
        return this.logPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPattern());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogPatternResponse)) {
            return false;
        }
        DescribeLogPatternResponse other = (DescribeLogPatternResponse)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.logPattern(), other.logPattern());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLogPatternResponse").add("ResourceGroupName", (Object)this.resourceGroupName()).add("LogPattern", (Object)this.logPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "LogPattern": {
                return Optional.ofNullable(clazz.cast(this.logPattern()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogPatternResponse, T> g) {
        return obj -> g.apply((DescribeLogPatternResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private LogPattern logPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogPatternResponse model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.logPattern(model.logPattern);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final LogPattern.Builder getLogPattern() {
            return this.logPattern != null ? this.logPattern.toBuilder() : null;
        }

        public final void setLogPattern(LogPattern.BuilderImpl logPattern) {
            this.logPattern = logPattern != null ? logPattern.build() : null;
        }

        @Override
        public final Builder logPattern(LogPattern logPattern) {
            this.logPattern = logPattern;
            return this;
        }

        @Override
        public DescribeLogPatternResponse build() {
            return new DescribeLogPatternResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLogPatternResponse> {
        public Builder resourceGroupName(String var1);

        public Builder logPattern(LogPattern var1);

        default public Builder logPattern(Consumer<LogPattern.Builder> logPattern) {
            return this.logPattern((LogPattern)((LogPattern.Builder)LogPattern.builder().applyMutation(logPattern)).build());
        }
    }
}

