/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Tier {
    CUSTOM("CUSTOM"),
    DEFAULT("DEFAULT"),
    DOT_NET_CORE("DOT_NET_CORE"),
    DOT_NET_WORKER("DOT_NET_WORKER"),
    DOT_NET_WEB_TIER("DOT_NET_WEB_TIER"),
    DOT_NET_WEB("DOT_NET_WEB"),
    SQL_SERVER("SQL_SERVER"),
    SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP("SQL_SERVER_ALWAYSON_AVAILABILITY_GROUP"),
    MYSQL("MYSQL"),
    POSTGRESQL("POSTGRESQL"),
    JAVA_JMX("JAVA_JMX"),
    ORACLE("ORACLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Tier> VALUE_MAP;
    private final String value;

    private Tier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Tier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Tier> knownValues() {
        EnumSet<Tier> knownValues = EnumSet.allOf(Tier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Tier.class, Tier::toString);
    }
}

