/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLogPatternRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, DeleteLogPatternRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(DeleteLogPatternRequest.getter(DeleteLogPatternRequest::resourceGroupName)).setter(DeleteLogPatternRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternSetName").getter(DeleteLogPatternRequest.getter(DeleteLogPatternRequest::patternSetName)).setter(DeleteLogPatternRequest.setter(Builder::patternSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()}).build();
    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PatternName").getter(DeleteLogPatternRequest.getter(DeleteLogPatternRequest::patternName)).setter(DeleteLogPatternRequest.setter(Builder::patternName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, PATTERN_SET_NAME_FIELD, PATTERN_NAME_FIELD));
    private final String resourceGroupName;
    private final String patternSetName;
    private final String patternName;

    private DeleteLogPatternRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String patternSetName() {
        return this.patternSetName;
    }

    public final String patternName() {
        return this.patternName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.patternName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLogPatternRequest)) {
            return false;
        }
        DeleteLogPatternRequest other = (DeleteLogPatternRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.patternSetName(), other.patternSetName()) && Objects.equals(this.patternName(), other.patternName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLogPatternRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("PatternSetName", (Object)this.patternSetName()).add("PatternName", (Object)this.patternName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "PatternSetName": {
                return Optional.ofNullable(clazz.cast(this.patternSetName()));
            }
            case "PatternName": {
                return Optional.ofNullable(clazz.cast(this.patternName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLogPatternRequest, T> g) {
        return obj -> g.apply((DeleteLogPatternRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String patternSetName;
        private String patternName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLogPatternRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.patternSetName(model.patternSetName);
            this.patternName(model.patternName);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        @Transient
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getPatternSetName() {
            return this.patternSetName;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        @Override
        @Transient
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final String getPatternName() {
            return this.patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        @Transient
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLogPatternRequest build() {
            return new DeleteLogPatternRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLogPatternRequest> {
        public Builder resourceGroupName(String var1);

        public Builder patternSetName(String var1);

        public Builder patternName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

