/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FeedbackValue {
    NOT_SPECIFIED("NOT_SPECIFIED"),
    USEFUL("USEFUL"),
    NOT_USEFUL("NOT_USEFUL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FeedbackValue> VALUE_MAP;
    private final String value;

    private FeedbackValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FeedbackValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FeedbackValue> knownValues() {
        EnumSet<FeedbackValue> knownValues = EnumSet.allOf(FeedbackValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FeedbackValue.class, FeedbackValue::toString);
    }
}

