/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the workloads on a component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workload implements SdkPojo, Serializable, ToCopyableBuilder<Workload.Builder, Workload> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(Workload::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(Workload::componentName)).setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(Workload::workloadName)).setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(Workload::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> WORKLOAD_REMARKS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadRemarks").getter(getter(Workload::workloadRemarks)).setter(setter(Builder::workloadRemarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadRemarks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            COMPONENT_NAME_FIELD, WORKLOAD_NAME_FIELD, TIER_FIELD, WORKLOAD_REMARKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String workloadId;

    private final String componentName;

    private final String workloadName;

    private final String tier;

    private final String workloadRemarks;

    private Workload(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.componentName = builder.componentName;
        this.workloadName = builder.workloadName;
        this.tier = builder.tier;
        this.workloadRemarks = builder.workloadRemarks;
    }

    /**
     * <p>
     * The ID of the workload.
     * </p>
     * 
     * @return The ID of the workload.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The name of the workload.
     * </p>
     * 
     * @return The name of the workload.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * <p>
     * The tier of the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the workload.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The tier of the workload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the workload.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * If logging is supported for the resource type, shows whether the component has configured logs to be monitored.
     * </p>
     * 
     * @return If logging is supported for the resource type, shows whether the component has configured logs to be
     *         monitored.
     */
    public final String workloadRemarks() {
        return workloadRemarks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadRemarks());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workload)) {
            return false;
        }
        Workload other = (Workload) obj;
        return Objects.equals(workloadId(), other.workloadId()) && Objects.equals(componentName(), other.componentName())
                && Objects.equals(workloadName(), other.workloadName()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(workloadRemarks(), other.workloadRemarks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workload").add("WorkloadId", workloadId()).add("ComponentName", componentName())
                .add("WorkloadName", workloadName()).add("Tier", tierAsString()).add("WorkloadRemarks", workloadRemarks())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "WorkloadRemarks":
            return Optional.ofNullable(clazz.cast(workloadRemarks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Workload, T> g) {
        return obj -> g.apply((Workload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workload> {
        /**
         * <p>
         * The ID of the workload.
         * </p>
         * 
         * @param workloadId
         *        The ID of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The name of the workload.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * <p>
         * The tier of the workload.
         * </p>
         * 
         * @param tier
         *        The tier of the workload.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier of the workload.
         * </p>
         * 
         * @param tier
         *        The tier of the workload.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * If logging is supported for the resource type, shows whether the component has configured logs to be
         * monitored.
         * </p>
         * 
         * @param workloadRemarks
         *        If logging is supported for the resource type, shows whether the component has configured logs to be
         *        monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadRemarks(String workloadRemarks);
    }

    static final class BuilderImpl implements Builder {
        private String workloadId;

        private String componentName;

        private String workloadName;

        private String tier;

        private String workloadRemarks;

        private BuilderImpl() {
        }

        private BuilderImpl(Workload model) {
            workloadId(model.workloadId);
            componentName(model.componentName);
            workloadName(model.workloadName);
            tier(model.tier);
            workloadRemarks(model.workloadRemarks);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getWorkloadRemarks() {
            return workloadRemarks;
        }

        public final void setWorkloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
        }

        @Override
        public final Builder workloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
            return this;
        }

        @Override
        public Workload build() {
            return new Workload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
