/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationinsights.ApplicationInsightsAsyncClient;
import software.amazon.awssdk.services.applicationinsights.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsRequest;
import software.amazon.awssdk.services.applicationinsights.model.ListLogPatternSetsResponse;

public class ListLogPatternSetsPublisher
implements SdkPublisher<ListLogPatternSetsResponse> {
    private final ApplicationInsightsAsyncClient client;
    private final ListLogPatternSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogPatternSetsPublisher(ApplicationInsightsAsyncClient client, ListLogPatternSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogPatternSetsPublisher(ApplicationInsightsAsyncClient client, ListLogPatternSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogPatternSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogPatternSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLogPatternSetsResponseFetcher
    implements AsyncPageFetcher<ListLogPatternSetsResponse> {
        private ListLogPatternSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogPatternSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogPatternSetsResponse> nextPage(ListLogPatternSetsResponse previousPage) {
            if (previousPage == null) {
                return ListLogPatternSetsPublisher.this.client.listLogPatternSets(ListLogPatternSetsPublisher.this.firstRequest);
            }
            return ListLogPatternSetsPublisher.this.client.listLogPatternSets((ListLogPatternSetsRequest)((Object)ListLogPatternSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

