/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The event information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationEvent.Builder, ConfigurationEvent> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(ConfigurationEvent::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ConfigurationEvent::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> MONITORED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoredResourceARN").getter(getter(ConfigurationEvent::monitoredResourceARN))
            .setter(setter(Builder::monitoredResourceARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceARN").build())
            .build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventStatus").getter(getter(ConfigurationEvent::eventStatusAsString))
            .setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStatus").build()).build();

    private static final SdkField<String> EVENT_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventResourceType").getter(getter(ConfigurationEvent::eventResourceTypeAsString))
            .setter(setter(Builder::eventResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceType").build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTime").getter(getter(ConfigurationEvent::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()).build();

    private static final SdkField<String> EVENT_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDetail").getter(getter(ConfigurationEvent::eventDetail)).setter(setter(Builder::eventDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetail").build()).build();

    private static final SdkField<String> EVENT_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventResourceName").getter(getter(ConfigurationEvent::eventResourceName))
            .setter(setter(Builder::eventResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventResourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            ACCOUNT_ID_FIELD, MONITORED_RESOURCE_ARN_FIELD, EVENT_STATUS_FIELD, EVENT_RESOURCE_TYPE_FIELD, EVENT_TIME_FIELD,
            EVENT_DETAIL_FIELD, EVENT_RESOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceGroupName;

    private final String accountId;

    private final String monitoredResourceARN;

    private final String eventStatus;

    private final String eventResourceType;

    private final Instant eventTime;

    private final String eventDetail;

    private final String eventResourceName;

    private ConfigurationEvent(BuilderImpl builder) {
        this.resourceGroupName = builder.resourceGroupName;
        this.accountId = builder.accountId;
        this.monitoredResourceARN = builder.monitoredResourceARN;
        this.eventStatus = builder.eventStatus;
        this.eventResourceType = builder.eventResourceType;
        this.eventTime = builder.eventTime;
        this.eventDetail = builder.eventDetail;
        this.eventResourceName = builder.eventResourceName;
    }

    /**
     * <p>
     * The name of the resource group of the application to which the configuration event belongs.
     * </p>
     * 
     * @return The name of the resource group of the application to which the configuration event belongs.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the owner of the application to which the configuration event belongs.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the owner of the application to which the configuration event
     *         belongs.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The resource monitored by Application Insights.
     * </p>
     * 
     * @return The resource monitored by Application Insights.
     */
    public final String monitoredResourceARN() {
        return monitoredResourceARN;
    }

    /**
     * <p>
     * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link ConfigurationEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     * @see ConfigurationEventStatus
     */
    public final ConfigurationEventStatus eventStatus() {
        return ConfigurationEventStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link ConfigurationEventStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
     * @see ConfigurationEventStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    /**
     * <p>
     * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventResourceType}
     * will return {@link ConfigurationEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #eventResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
     * @see ConfigurationEventResourceType
     */
    public final ConfigurationEventResourceType eventResourceType() {
        return ConfigurationEventResourceType.fromValue(eventResourceType);
    }

    /**
     * <p>
     * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventResourceType}
     * will return {@link ConfigurationEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #eventResourceTypeAsString}.
     * </p>
     * 
     * @return The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
     * @see ConfigurationEventResourceType
     */
    public final String eventResourceTypeAsString() {
        return eventResourceType;
    }

    /**
     * <p>
     * The timestamp of the event.
     * </p>
     * 
     * @return The timestamp of the event.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * The details of the event in plain text.
     * </p>
     * 
     * @return The details of the event in plain text.
     */
    public final String eventDetail() {
        return eventDetail;
    }

    /**
     * <p>
     * The name of the resource Application Insights attempted to configure.
     * </p>
     * 
     * @return The name of the resource Application Insights attempted to configure.
     */
    public final String eventResourceName() {
        return eventResourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(monitoredResourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventDetail());
        hashCode = 31 * hashCode + Objects.hashCode(eventResourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationEvent)) {
            return false;
        }
        ConfigurationEvent other = (ConfigurationEvent) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(monitoredResourceARN(), other.monitoredResourceARN())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString())
                && Objects.equals(eventResourceTypeAsString(), other.eventResourceTypeAsString())
                && Objects.equals(eventTime(), other.eventTime()) && Objects.equals(eventDetail(), other.eventDetail())
                && Objects.equals(eventResourceName(), other.eventResourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationEvent").add("ResourceGroupName", resourceGroupName()).add("AccountId", accountId())
                .add("MonitoredResourceARN", monitoredResourceARN()).add("EventStatus", eventStatusAsString())
                .add("EventResourceType", eventResourceTypeAsString()).add("EventTime", eventTime())
                .add("EventDetail", eventDetail()).add("EventResourceName", eventResourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "MonitoredResourceARN":
            return Optional.ofNullable(clazz.cast(monitoredResourceARN()));
        case "EventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        case "EventResourceType":
            return Optional.ofNullable(clazz.cast(eventResourceTypeAsString()));
        case "EventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "EventDetail":
            return Optional.ofNullable(clazz.cast(eventDetail()));
        case "EventResourceName":
            return Optional.ofNullable(clazz.cast(eventResourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("MonitoredResourceARN", MONITORED_RESOURCE_ARN_FIELD);
        map.put("EventStatus", EVENT_STATUS_FIELD);
        map.put("EventResourceType", EVENT_RESOURCE_TYPE_FIELD);
        map.put("EventTime", EVENT_TIME_FIELD);
        map.put("EventDetail", EVENT_DETAIL_FIELD);
        map.put("EventResourceName", EVENT_RESOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationEvent, T> g) {
        return obj -> g.apply((ConfigurationEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationEvent> {
        /**
         * <p>
         * The name of the resource group of the application to which the configuration event belongs.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group of the application to which the configuration event belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The Amazon Web Services account ID for the owner of the application to which the configuration event belongs.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the owner of the application to which the configuration event
         *        belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The resource monitored by Application Insights.
         * </p>
         * 
         * @param monitoredResourceARN
         *        The resource monitored by Application Insights.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoredResourceARN(String monitoredResourceARN);

        /**
         * <p>
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         * </p>
         * 
         * @param eventStatus
         *        The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         * @see ConfigurationEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationEventStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         * </p>
         * 
         * @param eventStatus
         *        The status of the configuration update event. Possible values include INFO, WARN, and ERROR.
         * @see ConfigurationEventStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationEventStatus
         */
        Builder eventStatus(ConfigurationEventStatus eventStatus);

        /**
         * <p>
         * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         * </p>
         * 
         * @param eventResourceType
         *        The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         * @see ConfigurationEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationEventResourceType
         */
        Builder eventResourceType(String eventResourceType);

        /**
         * <p>
         * The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         * </p>
         * 
         * @param eventResourceType
         *        The resource type that Application Insights attempted to configure, for example, CLOUDWATCH_ALARM.
         * @see ConfigurationEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationEventResourceType
         */
        Builder eventResourceType(ConfigurationEventResourceType eventResourceType);

        /**
         * <p>
         * The timestamp of the event.
         * </p>
         * 
         * @param eventTime
         *        The timestamp of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * The details of the event in plain text.
         * </p>
         * 
         * @param eventDetail
         *        The details of the event in plain text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDetail(String eventDetail);

        /**
         * <p>
         * The name of the resource Application Insights attempted to configure.
         * </p>
         * 
         * @param eventResourceName
         *        The name of the resource Application Insights attempted to configure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventResourceName(String eventResourceName);
    }

    static final class BuilderImpl implements Builder {
        private String resourceGroupName;

        private String accountId;

        private String monitoredResourceARN;

        private String eventStatus;

        private String eventResourceType;

        private Instant eventTime;

        private String eventDetail;

        private String eventResourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationEvent model) {
            resourceGroupName(model.resourceGroupName);
            accountId(model.accountId);
            monitoredResourceARN(model.monitoredResourceARN);
            eventStatus(model.eventStatus);
            eventResourceType(model.eventResourceType);
            eventTime(model.eventTime);
            eventDetail(model.eventDetail);
            eventResourceName(model.eventResourceName);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getMonitoredResourceARN() {
            return monitoredResourceARN;
        }

        public final void setMonitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
        }

        @Override
        public final Builder monitoredResourceARN(String monitoredResourceARN) {
            this.monitoredResourceARN = monitoredResourceARN;
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(ConfigurationEventStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public final String getEventResourceType() {
            return eventResourceType;
        }

        public final void setEventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
        }

        @Override
        public final Builder eventResourceType(String eventResourceType) {
            this.eventResourceType = eventResourceType;
            return this;
        }

        @Override
        public final Builder eventResourceType(ConfigurationEventResourceType eventResourceType) {
            this.eventResourceType(eventResourceType == null ? null : eventResourceType.toString());
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getEventDetail() {
            return eventDetail;
        }

        public final void setEventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
        }

        @Override
        public final Builder eventDetail(String eventDetail) {
            this.eventDetail = eventDetail;
            return this;
        }

        public final String getEventResourceName() {
            return eventResourceName;
        }

        public final void setEventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
        }

        @Override
        public final Builder eventResourceName(String eventResourceName) {
            this.eventResourceName = eventResourceName;
            return this;
        }

        @Override
        public ConfigurationEvent build() {
            return new ConfigurationEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
