/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLogPatternsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<ListLogPatternsResponse.Builder, ListLogPatternsResponse> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(ListLogPatternsResponse::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListLogPatternsResponse::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<List<LogPattern>> LOG_PATTERNS_FIELD = SdkField
            .<List<LogPattern>> builder(MarshallingType.LIST)
            .memberName("LogPatterns")
            .getter(getter(ListLogPatternsResponse::logPatterns))
            .setter(setter(Builder::logPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogPattern> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogPattern::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLogPatternsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            ACCOUNT_ID_FIELD, LOG_PATTERNS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceGroupName;

    private final String accountId;

    private final List<LogPattern> logPatterns;

    private final String nextToken;

    private ListLogPatternsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.accountId = builder.accountId;
        this.logPatterns = builder.logPatterns;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the resource group owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the resource group owner.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogPatterns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogPatterns() {
        return logPatterns != null && !(logPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log patterns.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPatterns} method.
     * </p>
     * 
     * @return The list of log patterns.
     */
    public final List<LogPattern> logPatterns() {
        return logPatterns;
    }

    /**
     * <p>
     * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token used to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogPatterns() ? logPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLogPatternsResponse)) {
            return false;
        }
        ListLogPatternsResponse other = (ListLogPatternsResponse) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName()) && Objects.equals(accountId(), other.accountId())
                && hasLogPatterns() == other.hasLogPatterns() && Objects.equals(logPatterns(), other.logPatterns())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLogPatternsResponse").add("ResourceGroupName", resourceGroupName())
                .add("AccountId", accountId()).add("LogPatterns", hasLogPatterns() ? logPatterns() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "LogPatterns":
            return Optional.ofNullable(clazz.cast(logPatterns()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("LogPatterns", LOG_PATTERNS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLogPatternsResponse, T> g) {
        return obj -> g.apply((ListLogPatternsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLogPatternsResponse> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The Amazon Web Services account ID for the resource group owner.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the resource group owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * 
         * @param logPatterns
         *        The list of log patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatterns(Collection<LogPattern> logPatterns);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * 
         * @param logPatterns
         *        The list of log patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPatterns(LogPattern... logPatterns);

        /**
         * <p>
         * The list of log patterns.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationinsights.model.LogPattern.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationinsights.model.LogPattern#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationinsights.model.LogPattern.Builder#build()} is called
         * immediately and its result is passed to {@link #logPatterns(List<LogPattern>)}.
         * 
         * @param logPatterns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationinsights.model.LogPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPatterns(java.util.Collection<LogPattern>)
         */
        Builder logPatterns(Consumer<LogPattern.Builder>... logPatterns);

        /**
         * <p>
         * The token used to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String accountId;

        private List<LogPattern> logPatterns = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLogPatternsResponse model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            accountId(model.accountId);
            logPatterns(model.logPatterns);
            nextToken(model.nextToken);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<LogPattern.Builder> getLogPatterns() {
            List<LogPattern.Builder> result = LogPatternListCopier.copyToBuilder(this.logPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogPatterns(Collection<LogPattern.BuilderImpl> logPatterns) {
            this.logPatterns = LogPatternListCopier.copyFromBuilder(logPatterns);
        }

        @Override
        public final Builder logPatterns(Collection<LogPattern> logPatterns) {
            this.logPatterns = LogPatternListCopier.copy(logPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(LogPattern... logPatterns) {
            logPatterns(Arrays.asList(logPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPatterns(Consumer<LogPattern.Builder>... logPatterns) {
            logPatterns(Stream.of(logPatterns).map(c -> LogPattern.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLogPatternsResponse build() {
            return new ListLogPatternsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
