/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateComponentConfigurationRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<UpdateComponentConfigurationRequest.Builder, UpdateComponentConfigurationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName").getter(getter(UpdateComponentConfigurationRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(UpdateComponentConfigurationRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Monitor").getter(getter(UpdateComponentConfigurationRequest::monitor)).setter(setter(Builder::monitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(UpdateComponentConfigurationRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> COMPONENT_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentConfiguration").getter(getter(UpdateComponentConfigurationRequest::componentConfiguration))
            .setter(setter(Builder::componentConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentConfiguration").build())
            .build();

    private static final SdkField<Boolean> AUTO_CONFIG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoConfigEnabled").getter(getter(UpdateComponentConfigurationRequest::autoConfigEnabled))
            .setter(setter(Builder::autoConfigEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoConfigEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            COMPONENT_NAME_FIELD, MONITOR_FIELD, TIER_FIELD, COMPONENT_CONFIGURATION_FIELD, AUTO_CONFIG_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceGroupName;

    private final String componentName;

    private final Boolean monitor;

    private final String tier;

    private final String componentConfiguration;

    private final Boolean autoConfigEnabled;

    private UpdateComponentConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.monitor = builder.monitor;
        this.tier = builder.tier;
        this.componentConfiguration = builder.componentConfiguration;
        this.autoConfigEnabled = builder.autoConfigEnabled;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * Indicates whether the application component is monitored.
     * </p>
     * 
     * @return Indicates whether the application component is monitored.
     */
    public final Boolean monitor() {
        return monitor;
    }

    /**
     * <p>
     * The tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The configuration settings of the component. The value is the escaped JSON of the configuration. For more
     * information about the JSON format, see <a
     * href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with
     * JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the
     * recommended configuration for a component. For the complete format of the component configuration file, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component
     * Configuration</a>.
     * </p>
     * 
     * @return The configuration settings of the component. The value is the escaped JSON of the configuration. For more
     *         information about the JSON format, see <a
     *         href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working
     *         with JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see
     *         the recommended configuration for a component. For the complete format of the component configuration
     *         file, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component
     *         Configuration</a>.
     */
    public final String componentConfiguration() {
        return componentConfiguration;
    }

    /**
     * <p>
     * Automatically configures the component by applying the recommended configurations.
     * </p>
     * 
     * @return Automatically configures the component by applying the recommended configurations.
     */
    public final Boolean autoConfigEnabled() {
        return autoConfigEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(monitor());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(componentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoConfigEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateComponentConfigurationRequest)) {
            return false;
        }
        UpdateComponentConfigurationRequest other = (UpdateComponentConfigurationRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(componentName(), other.componentName()) && Objects.equals(monitor(), other.monitor())
                && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(componentConfiguration(), other.componentConfiguration())
                && Objects.equals(autoConfigEnabled(), other.autoConfigEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateComponentConfigurationRequest").add("ResourceGroupName", resourceGroupName())
                .add("ComponentName", componentName()).add("Monitor", monitor()).add("Tier", tierAsString())
                .add("ComponentConfiguration", componentConfiguration()).add("AutoConfigEnabled", autoConfigEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "Monitor":
            return Optional.ofNullable(clazz.cast(monitor()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "ComponentConfiguration":
            return Optional.ofNullable(clazz.cast(componentConfiguration()));
        case "AutoConfigEnabled":
            return Optional.ofNullable(clazz.cast(autoConfigEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("Monitor", MONITOR_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("ComponentConfiguration", COMPONENT_CONFIGURATION_FIELD);
        map.put("AutoConfigEnabled", AUTO_CONFIG_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateComponentConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateComponentConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateComponentConfigurationRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * Indicates whether the application component is monitored.
         * </p>
         * 
         * @param monitor
         *        Indicates whether the application component is monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitor(Boolean monitor);

        /**
         * <p>
         * The tier of the application component.
         * </p>
         * 
         * @param tier
         *        The tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier of the application component.
         * </p>
         * 
         * @param tier
         *        The tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * The configuration settings of the component. The value is the escaped JSON of the configuration. For more
         * information about the JSON format, see <a
         * href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html">Working with
         * JSON</a>. You can send a request to <code>DescribeComponentConfigurationRecommendation</code> to see the
         * recommended configuration for a component. For the complete format of the component configuration file, see
         * <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component
         * Configuration</a>.
         * </p>
         * 
         * @param componentConfiguration
         *        The configuration settings of the component. The value is the escaped JSON of the configuration. For
         *        more information about the JSON format, see <a
         *        href="https://docs.aws.amazon.com/sdk-for-javascript/v2/developer-guide/working-with-json.html"
         *        >Working with JSON</a>. You can send a request to
         *        <code>DescribeComponentConfigurationRecommendation</code> to see the recommended configuration for a
         *        component. For the complete format of the component configuration file, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/component-config.html">Component
         *        Configuration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentConfiguration(String componentConfiguration);

        /**
         * <p>
         * Automatically configures the component by applying the recommended configurations.
         * </p>
         * 
         * @param autoConfigEnabled
         *        Automatically configures the component by applying the recommended configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoConfigEnabled(Boolean autoConfigEnabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String componentName;

        private Boolean monitor;

        private String tier;

        private String componentConfiguration;

        private Boolean autoConfigEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateComponentConfigurationRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            componentName(model.componentName);
            monitor(model.monitor);
            tier(model.tier);
            componentConfiguration(model.componentConfiguration);
            autoConfigEnabled(model.autoConfigEnabled);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final Boolean getMonitor() {
            return monitor;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getComponentConfiguration() {
            return componentConfiguration;
        }

        public final void setComponentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
        }

        @Override
        public final Builder componentConfiguration(String componentConfiguration) {
            this.componentConfiguration = componentConfiguration;
            return this;
        }

        public final Boolean getAutoConfigEnabled() {
            return autoConfigEnabled;
        }

        public final void setAutoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
        }

        @Override
        public final Builder autoConfigEnabled(Boolean autoConfigEnabled) {
            this.autoConfigEnabled = autoConfigEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateComponentConfigurationRequest build() {
            return new UpdateComponentConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
