/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProblemRequest extends ApplicationInsightsRequest implements
        ToCopyableBuilder<UpdateProblemRequest.Builder, UpdateProblemRequest> {
    private static final SdkField<String> PROBLEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProblemId").getter(getter(UpdateProblemRequest::problemId)).setter(setter(Builder::problemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemId").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateStatus").getter(getter(UpdateProblemRequest::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(UpdateProblemRequest::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROBLEM_ID_FIELD,
            UPDATE_STATUS_FIELD, VISIBILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String problemId;

    private final String updateStatus;

    private final String visibility;

    private UpdateProblemRequest(BuilderImpl builder) {
        super(builder);
        this.problemId = builder.problemId;
        this.updateStatus = builder.updateStatus;
        this.visibility = builder.visibility;
    }

    /**
     * <p>
     * The ID of the problem.
     * </p>
     * 
     * @return The ID of the problem.
     */
    public final String problemId() {
        return problemId;
    }

    /**
     * <p>
     * The status of the problem. Arguments can be passed for only problems that show a status of
     * <code>RECOVERING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The status of the problem. Arguments can be passed for only problems that show a status of
     *         <code>RECOVERING</code>.
     * @see UpdateStatus
     */
    public final UpdateStatus updateStatus() {
        return UpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * The status of the problem. Arguments can be passed for only problems that show a status of
     * <code>RECOVERING</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateStatusAsString}.
     * </p>
     * 
     * @return The status of the problem. Arguments can be passed for only problems that show a status of
     *         <code>RECOVERING</code>.
     * @see UpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    /**
     * <p>
     * The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from the
     * default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is passed, the
     * <code>IGNORED</code> action is reversed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from
     *         the default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is
     *         passed, the <code>IGNORED</code> action is reversed.
     * @see Visibility
     */
    public final Visibility visibility() {
        return Visibility.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from the
     * default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is passed, the
     * <code>IGNORED</code> action is reversed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from
     *         the default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is
     *         passed, the <code>IGNORED</code> action is reversed.
     * @see Visibility
     */
    public final String visibilityAsString() {
        return visibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(problemId());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProblemRequest)) {
            return false;
        }
        UpdateProblemRequest other = (UpdateProblemRequest) obj;
        return Objects.equals(problemId(), other.problemId())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString())
                && Objects.equals(visibilityAsString(), other.visibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProblemRequest").add("ProblemId", problemId()).add("UpdateStatus", updateStatusAsString())
                .add("Visibility", visibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProblemId":
            return Optional.ofNullable(clazz.cast(problemId()));
        case "UpdateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProblemId", PROBLEM_ID_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        map.put("Visibility", VISIBILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProblemRequest, T> g) {
        return obj -> g.apply((UpdateProblemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProblemRequest> {
        /**
         * <p>
         * The ID of the problem.
         * </p>
         * 
         * @param problemId
         *        The ID of the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder problemId(String problemId);

        /**
         * <p>
         * The status of the problem. Arguments can be passed for only problems that show a status of
         * <code>RECOVERING</code>.
         * </p>
         * 
         * @param updateStatus
         *        The status of the problem. Arguments can be passed for only problems that show a status of
         *        <code>RECOVERING</code>.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * The status of the problem. Arguments can be passed for only problems that show a status of
         * <code>RECOVERING</code>.
         * </p>
         * 
         * @param updateStatus
         *        The status of the problem. Arguments can be passed for only problems that show a status of
         *        <code>RECOVERING</code>.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder updateStatus(UpdateStatus updateStatus);

        /**
         * <p>
         * The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from the
         * default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is passed, the
         * <code>IGNORED</code> action is reversed.
         * </p>
         * 
         * @param visibility
         *        The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed
         *        from the default view, and all notifications for the problem are suspended. When <code>VISIBLE</code>
         *        is passed, the <code>IGNORED</code> action is reversed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed from the
         * default view, and all notifications for the problem are suspended. When <code>VISIBLE</code> is passed, the
         * <code>IGNORED</code> action is reversed.
         * </p>
         * 
         * @param visibility
         *        The visibility of a problem. When you pass a value of <code>IGNORED</code>, the problem is removed
         *        from the default view, and all notifications for the problem are suspended. When <code>VISIBLE</code>
         *        is passed, the <code>IGNORED</code> action is reversed.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder visibility(Visibility visibility);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String problemId;

        private String updateStatus;

        private String visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProblemRequest model) {
            super(model);
            problemId(model.problemId);
            updateStatus(model.updateStatus);
            visibility(model.visibility);
        }

        public final String getProblemId() {
            return problemId;
        }

        public final void setProblemId(String problemId) {
            this.problemId = problemId;
        }

        @Override
        public final Builder problemId(String problemId) {
            this.problemId = problemId;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(UpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProblemRequest build() {
            return new UpdateProblemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
