/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkloadResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<UpdateWorkloadResponse.Builder, UpdateWorkloadResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadId").getter(getter(UpdateWorkloadResponse::workloadId)).setter(setter(Builder::workloadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()).build();

    private static final SdkField<WorkloadConfiguration> WORKLOAD_CONFIGURATION_FIELD = SdkField
            .<WorkloadConfiguration> builder(MarshallingType.SDK_POJO).memberName("WorkloadConfiguration")
            .getter(getter(UpdateWorkloadResponse::workloadConfiguration)).setter(setter(Builder::workloadConfiguration))
            .constructor(WorkloadConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD,
            WORKLOAD_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workloadId;

    private final WorkloadConfiguration workloadConfiguration;

    private UpdateWorkloadResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.workloadConfiguration = builder.workloadConfiguration;
    }

    /**
     * <p>
     * The ID of the workload.
     * </p>
     * 
     * @return The ID of the workload.
     */
    public final String workloadId() {
        return workloadId;
    }

    /**
     * <p>
     * The configuration settings of the workload. The value is the escaped JSON of the configuration.
     * </p>
     * 
     * @return The configuration settings of the workload. The value is the escaped JSON of the configuration.
     */
    public final WorkloadConfiguration workloadConfiguration() {
        return workloadConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(workloadConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadResponse)) {
            return false;
        }
        UpdateWorkloadResponse other = (UpdateWorkloadResponse) obj;
        return Objects.equals(workloadId(), other.workloadId())
                && Objects.equals(workloadConfiguration(), other.workloadConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkloadResponse").add("WorkloadId", workloadId())
                .add("WorkloadConfiguration", workloadConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkloadId":
            return Optional.ofNullable(clazz.cast(workloadId()));
        case "WorkloadConfiguration":
            return Optional.ofNullable(clazz.cast(workloadConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        map.put("WorkloadConfiguration", WORKLOAD_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadResponse, T> g) {
        return obj -> g.apply((UpdateWorkloadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateWorkloadResponse> {
        /**
         * <p>
         * The ID of the workload.
         * </p>
         * 
         * @param workloadId
         *        The ID of the workload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadId(String workloadId);

        /**
         * <p>
         * The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * </p>
         * 
         * @param workloadConfiguration
         *        The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration);

        /**
         * <p>
         * The configuration settings of the workload. The value is the escaped JSON of the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkloadConfiguration.Builder} avoiding
         * the need to create one manually via {@link WorkloadConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkloadConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #workloadConfiguration(WorkloadConfiguration)}.
         * 
         * @param workloadConfiguration
         *        a consumer that will call methods on {@link WorkloadConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workloadConfiguration(WorkloadConfiguration)
         */
        default Builder workloadConfiguration(Consumer<WorkloadConfiguration.Builder> workloadConfiguration) {
            return workloadConfiguration(WorkloadConfiguration.builder().applyMutation(workloadConfiguration).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private String workloadId;

        private WorkloadConfiguration workloadConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadResponse model) {
            super(model);
            workloadId(model.workloadId);
            workloadConfiguration(model.workloadConfiguration);
        }

        public final String getWorkloadId() {
            return workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final WorkloadConfiguration.Builder getWorkloadConfiguration() {
            return workloadConfiguration != null ? workloadConfiguration.toBuilder() : null;
        }

        public final void setWorkloadConfiguration(WorkloadConfiguration.BuilderImpl workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration != null ? workloadConfiguration.build() : null;
        }

        @Override
        public final Builder workloadConfiguration(WorkloadConfiguration workloadConfiguration) {
            this.workloadConfiguration = workloadConfiguration;
            return this;
        }

        @Override
        public UpdateWorkloadResponse build() {
            return new UpdateWorkloadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
