/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsResponse;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEvent;
import software.amazon.awssdk.services.applicationinsights.model.ConfigurationEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationHistoryResponse
extends ApplicationInsightsResponse
implements ToCopyableBuilder<Builder, ListConfigurationHistoryResponse> {
    private static final SdkField<List<ConfigurationEvent>> EVENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventList").getter(ListConfigurationHistoryResponse.getter(ListConfigurationHistoryResponse::eventList)).setter(ListConfigurationHistoryResponse.setter(Builder::eventList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationHistoryResponse.getter(ListConfigurationHistoryResponse::nextToken)).setter(ListConfigurationHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigurationHistoryResponse.memberNameToFieldInitializer();
    private final List<ConfigurationEvent> eventList;
    private final String nextToken;

    private ListConfigurationHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.eventList = builder.eventList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEventList() {
        return this.eventList != null && !(this.eventList instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationEvent> eventList() {
        return this.eventList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventList() ? this.eventList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationHistoryResponse)) {
            return false;
        }
        ListConfigurationHistoryResponse other = (ListConfigurationHistoryResponse)((Object)obj);
        return this.hasEventList() == other.hasEventList() && Objects.equals(this.eventList(), other.eventList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationHistoryResponse").add("EventList", this.hasEventList() ? this.eventList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventList": {
                return Optional.ofNullable(clazz.cast(this.eventList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventList", EVENT_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationHistoryResponse, T> g) {
        return obj -> g.apply((ListConfigurationHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationEvent> eventList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationHistoryResponse model) {
            super(model);
            this.eventList(model.eventList);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationEvent.Builder> getEventList() {
            List<ConfigurationEvent.Builder> result = ConfigurationEventListCopier.copyToBuilder(this.eventList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventList(Collection<ConfigurationEvent.BuilderImpl> eventList) {
            this.eventList = ConfigurationEventListCopier.copyFromBuilder(eventList);
        }

        @Override
        public final Builder eventList(Collection<ConfigurationEvent> eventList) {
            this.eventList = ConfigurationEventListCopier.copy(eventList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(ConfigurationEvent ... eventList) {
            this.eventList(Arrays.asList(eventList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventList(Consumer<ConfigurationEvent.Builder> ... eventList) {
            this.eventList(Stream.of(eventList).map(c -> (ConfigurationEvent)((ConfigurationEvent.Builder)ConfigurationEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationHistoryResponse build() {
            return new ListConfigurationHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationHistoryResponse> {
        public Builder eventList(Collection<ConfigurationEvent> var1);

        public Builder eventList(ConfigurationEvent ... var1);

        public Builder eventList(Consumer<ConfigurationEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

