/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComponentConfigurationRecommendationRequest extends ApplicationInsightsRequest
        implements
        ToCopyableBuilder<DescribeComponentConfigurationRecommendationRequest.Builder, DescribeComponentConfigurationRecommendationRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceGroupName")
            .getter(getter(DescribeComponentConfigurationRecommendationRequest::resourceGroupName))
            .setter(setter(Builder::resourceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()).build();

    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(DescribeComponentConfigurationRecommendationRequest::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(DescribeComponentConfigurationRecommendationRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkloadName").getter(getter(DescribeComponentConfigurationRecommendationRequest::workloadName))
            .setter(setter(Builder::workloadName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()).build();

    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationType")
            .getter(getter(DescribeComponentConfigurationRecommendationRequest::recommendationTypeAsString))
            .setter(setter(Builder::recommendationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD,
            COMPONENT_NAME_FIELD, TIER_FIELD, WORKLOAD_NAME_FIELD, RECOMMENDATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceGroupName;

    private final String componentName;

    private final String tier;

    private final String workloadName;

    private final String recommendationType;

    private DescribeComponentConfigurationRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.tier = builder.tier;
        this.workloadName = builder.workloadName;
        this.recommendationType = builder.recommendationType;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String resourceGroupName() {
        return resourceGroupName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * The tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier of the application component.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * The name of the workload. The name of the workload is required when the tier of the application component is
     * <code>SAP_ASE_SINGLE_NODE</code> or <code>SAP_ASE_HIGH_AVAILABILITY</code>.
     * </p>
     * 
     * @return The name of the workload. The name of the workload is required when the tier of the application component
     *         is <code>SAP_ASE_SINGLE_NODE</code> or <code>SAP_ASE_HIGH_AVAILABILITY</code>.
     */
    public final String workloadName() {
        return workloadName;
    }

    /**
     * <p>
     * The recommended configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationType} will return {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendationTypeAsString}.
     * </p>
     * 
     * @return The recommended configuration type.
     * @see RecommendationType
     */
    public final RecommendationType recommendationType() {
        return RecommendationType.fromValue(recommendationType);
    }

    /**
     * <p>
     * The recommended configuration type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationType} will return {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #recommendationTypeAsString}.
     * </p>
     * 
     * @return The recommended configuration type.
     * @see RecommendationType
     */
    public final String recommendationTypeAsString() {
        return recommendationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComponentConfigurationRecommendationRequest)) {
            return false;
        }
        DescribeComponentConfigurationRecommendationRequest other = (DescribeComponentConfigurationRecommendationRequest) obj;
        return Objects.equals(resourceGroupName(), other.resourceGroupName())
                && Objects.equals(componentName(), other.componentName()) && Objects.equals(tierAsString(), other.tierAsString())
                && Objects.equals(workloadName(), other.workloadName())
                && Objects.equals(recommendationTypeAsString(), other.recommendationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComponentConfigurationRecommendationRequest")
                .add("ResourceGroupName", resourceGroupName()).add("ComponentName", componentName()).add("Tier", tierAsString())
                .add("WorkloadName", workloadName()).add("RecommendationType", recommendationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceGroupName":
            return Optional.ofNullable(clazz.cast(resourceGroupName()));
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "WorkloadName":
            return Optional.ofNullable(clazz.cast(workloadName()));
        case "RecommendationType":
            return Optional.ofNullable(clazz.cast(recommendationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("Tier", TIER_FIELD);
        map.put("WorkloadName", WORKLOAD_NAME_FIELD);
        map.put("RecommendationType", RECOMMENDATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComponentConfigurationRecommendationRequest, T> g) {
        return obj -> g.apply((DescribeComponentConfigurationRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationInsightsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeComponentConfigurationRecommendationRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param resourceGroupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupName(String resourceGroupName);

        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * The tier of the application component.
         * </p>
         * 
         * @param tier
         *        The tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier of the application component.
         * </p>
         * 
         * @param tier
         *        The tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * The name of the workload. The name of the workload is required when the tier of the application component is
         * <code>SAP_ASE_SINGLE_NODE</code> or <code>SAP_ASE_HIGH_AVAILABILITY</code>.
         * </p>
         * 
         * @param workloadName
         *        The name of the workload. The name of the workload is required when the tier of the application
         *        component is <code>SAP_ASE_SINGLE_NODE</code> or <code>SAP_ASE_HIGH_AVAILABILITY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workloadName(String workloadName);

        /**
         * <p>
         * The recommended configuration type.
         * </p>
         * 
         * @param recommendationType
         *        The recommended configuration type.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder recommendationType(String recommendationType);

        /**
         * <p>
         * The recommended configuration type.
         * </p>
         * 
         * @param recommendationType
         *        The recommended configuration type.
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder recommendationType(RecommendationType recommendationType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationInsightsRequest.BuilderImpl implements Builder {
        private String resourceGroupName;

        private String componentName;

        private String tier;

        private String workloadName;

        private String recommendationType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComponentConfigurationRecommendationRequest model) {
            super(model);
            resourceGroupName(model.resourceGroupName);
            componentName(model.componentName);
            tier(model.tier);
            workloadName(model.workloadName);
            recommendationType(model.recommendationType);
        }

        public final String getResourceGroupName() {
            return resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getWorkloadName() {
            return workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getRecommendationType() {
            return recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        @Override
        public final Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType(recommendationType == null ? null : recommendationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComponentConfigurationRecommendationRequest build() {
            return new DescribeComponentConfigurationRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
