/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.ApplicationInsightsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveWorkloadRequest
extends ApplicationInsightsRequest
implements ToCopyableBuilder<Builder, RemoveWorkloadRequest> {
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceGroupName").getter(RemoveWorkloadRequest.getter(RemoveWorkloadRequest::resourceGroupName)).setter(RemoveWorkloadRequest.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceGroupName").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(RemoveWorkloadRequest.getter(RemoveWorkloadRequest::componentName)).setter(RemoveWorkloadRequest.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(RemoveWorkloadRequest.getter(RemoveWorkloadRequest::workloadId)).setter(RemoveWorkloadRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_GROUP_NAME_FIELD, COMPONENT_NAME_FIELD, WORKLOAD_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveWorkloadRequest.memberNameToFieldInitializer();
    private final String resourceGroupName;
    private final String componentName;
    private final String workloadId;

    private RemoveWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.resourceGroupName = builder.resourceGroupName;
        this.componentName = builder.componentName;
        this.workloadId = builder.workloadId;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveWorkloadRequest)) {
            return false;
        }
        RemoveWorkloadRequest other = (RemoveWorkloadRequest)((Object)obj);
        return Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.workloadId(), other.workloadId());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveWorkloadRequest").add("ResourceGroupName", (Object)this.resourceGroupName()).add("ComponentName", (Object)this.componentName()).add("WorkloadId", (Object)this.workloadId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceGroupName", RESOURCE_GROUP_NAME_FIELD);
        map.put("ComponentName", COMPONENT_NAME_FIELD);
        map.put("WorkloadId", WORKLOAD_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveWorkloadRequest, T> g) {
        return obj -> g.apply((RemoveWorkloadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationInsightsRequest.BuilderImpl
    implements Builder {
        private String resourceGroupName;
        private String componentName;
        private String workloadId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveWorkloadRequest model) {
            super(model);
            this.resourceGroupName(model.resourceGroupName);
            this.componentName(model.componentName);
            this.workloadId(model.workloadId);
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveWorkloadRequest build() {
            return new RemoveWorkloadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationInsightsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveWorkloadRequest> {
        public Builder resourceGroupName(String var1);

        public Builder componentName(String var1);

        public Builder workloadId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

