/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceLevelObjectiveResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<CreateServiceLevelObjectiveResponse.Builder, CreateServiceLevelObjectiveResponse> {
    private static final SdkField<ServiceLevelObjective> SLO_FIELD = SdkField
            .<ServiceLevelObjective> builder(MarshallingType.SDK_POJO).memberName("Slo")
            .getter(getter(CreateServiceLevelObjectiveResponse::slo)).setter(setter(Builder::slo))
            .constructor(ServiceLevelObjective::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Slo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLO_FIELD));

    private final ServiceLevelObjective slo;

    private CreateServiceLevelObjectiveResponse(BuilderImpl builder) {
        super(builder);
        this.slo = builder.slo;
    }

    /**
     * <p>
     * A structure that contains information about the SLO that you just created.
     * </p>
     * 
     * @return A structure that contains information about the SLO that you just created.
     */
    public final ServiceLevelObjective slo() {
        return slo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(slo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceLevelObjectiveResponse)) {
            return false;
        }
        CreateServiceLevelObjectiveResponse other = (CreateServiceLevelObjectiveResponse) obj;
        return Objects.equals(slo(), other.slo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceLevelObjectiveResponse").add("Slo", slo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Slo":
            return Optional.ofNullable(clazz.cast(slo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceLevelObjectiveResponse, T> g) {
        return obj -> g.apply((CreateServiceLevelObjectiveResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceLevelObjectiveResponse> {
        /**
         * <p>
         * A structure that contains information about the SLO that you just created.
         * </p>
         * 
         * @param slo
         *        A structure that contains information about the SLO that you just created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slo(ServiceLevelObjective slo);

        /**
         * <p>
         * A structure that contains information about the SLO that you just created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelObjective.Builder} avoiding
         * the need to create one manually via {@link ServiceLevelObjective#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelObjective.Builder#build()} is called immediately and
         * its result is passed to {@link #slo(ServiceLevelObjective)}.
         * 
         * @param slo
         *        a consumer that will call methods on {@link ServiceLevelObjective.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #slo(ServiceLevelObjective)
         */
        default Builder slo(Consumer<ServiceLevelObjective.Builder> slo) {
            return slo(ServiceLevelObjective.builder().applyMutation(slo).build());
        }
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private ServiceLevelObjective slo;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceLevelObjectiveResponse model) {
            super(model);
            slo(model.slo);
        }

        public final ServiceLevelObjective.Builder getSlo() {
            return slo != null ? slo.toBuilder() : null;
        }

        public final void setSlo(ServiceLevelObjective.BuilderImpl slo) {
            this.slo = slo != null ? slo.build() : null;
        }

        @Override
        public final Builder slo(ServiceLevelObjective slo) {
            this.slo = slo;
            return this;
        }

        @Override
        public CreateServiceLevelObjectiveResponse build() {
            return new CreateServiceLevelObjectiveResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
