/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<ListServicesRequest.Builder, ListServicesRequest> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListServicesRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListServicesRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("EndTime").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListServicesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final Instant startTime;

    private final Instant endTime;

    private final Integer maxResults;

    private final String nextToken;

    private ListServicesRequest(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as
     * be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * Your requested start time will be rounded to the nearest hour.
     * </p>
     * 
     * @return The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is
     *         formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         Your requested start time will be rounded to the nearest hour.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted as
     * be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * Your requested start time will be rounded to the nearest hour.
     * </p>
     * 
     * @return The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is
     *         formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         Your requested start time will be rounded to the nearest hour.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.
     * </p>
     * 
     * @return The maximum number of results to return in one operation. If you omit this parameter, the default of 50
     *         is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Include this value, if it was returned by the previous operation, to get the next set of services.
     * </p>
     * 
     * @return Include this value, if it was returned by the previous operation, to get the next set of services.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesRequest)) {
            return false;
        }
        ListServicesRequest other = (ListServicesRequest) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesRequest").add("StartTime", startTime()).add("EndTime", endTime())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesRequest, T> g) {
        return obj -> g.apply((ListServicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesRequest> {
        /**
         * <p>
         * The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is
         * formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * Your requested start time will be rounded to the nearest hour.
         * </p>
         * 
         * @param startTime
         *        The start of the time period to retrieve information about. When used in a raw HTTP Query API, it is
         *        formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        Your requested start time will be rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is formatted
         * as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * Your requested start time will be rounded to the nearest hour.
         * </p>
         * 
         * @param endTime
         *        The end of the time period to retrieve information about. When used in a raw HTTP Query API, it is
         *        formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        Your requested start time will be rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is
         * used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in one operation. If you omit this parameter, the default of
         *        50 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Include this value, if it was returned by the previous operation, to get the next set of services.
         * </p>
         * 
         * @param nextToken
         *        Include this value, if it was returned by the previous operation, to get the next set of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesRequest model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServicesRequest build() {
            return new ListServicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
