/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesResponse extends ApplicationSignalsResponse implements
        ToCopyableBuilder<ListServicesResponse.Builder, ListServicesResponse> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ListServicesResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ListServicesResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<List<ServiceSummary>> SERVICE_SUMMARIES_FIELD = SdkField
            .<List<ServiceSummary>> builder(MarshallingType.LIST)
            .memberName("ServiceSummaries")
            .getter(getter(ListServicesResponse::serviceSummaries))
            .setter(setter(Builder::serviceSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, SERVICE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final Instant startTime;

    private final Instant endTime;

    private final List<ServiceSummary> serviceSummaries;

    private final String nextToken;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.serviceSummaries = builder.serviceSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
     * formatted as be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The start of the time period that the returned information applies to. When used in a raw HTTP Query API,
     *         it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
     * formatted as be epoch time in seconds. For example: <code>1698778057</code>
     * </p>
     * <p>
     * This displays the time that Application Signals used for the request. It might not match your request exactly,
     * because it was rounded to the nearest hour.
     * </p>
     * 
     * @return The end of the time period that the returned information applies to. When used in a raw HTTP Query API,
     *         it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
     *         <p>
     *         This displays the time that Application Signals used for the request. It might not match your request
     *         exactly, because it was rounded to the nearest hour.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceSummaries() {
        return serviceSummaries != null && !(serviceSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures, where each structure contains some information about a service. To get complete
     * information about a service, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html">GetService</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceSummaries} method.
     * </p>
     * 
     * @return An array of structures, where each structure contains some information about a service. To get complete
     *         information about a service, use <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html"
     *         >GetService</a>.
     */
    public final List<ServiceSummary> serviceSummaries() {
        return serviceSummaries;
    }

    /**
     * <p>
     * Include this value in your next use of this API to get next set of services.
     * </p>
     * 
     * @return Include this value in your next use of this API to get next set of services.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceSummaries() ? serviceSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasServiceSummaries() == other.hasServiceSummaries()
                && Objects.equals(serviceSummaries(), other.serviceSummaries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServicesResponse").add("StartTime", startTime()).add("EndTime", endTime())
                .add("ServiceSummaries", hasServiceSummaries() ? serviceSummaries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "ServiceSummaries":
            return Optional.ofNullable(clazz.cast(serviceSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesResponse> {
        /**
         * <p>
         * The start of the time period that the returned information applies to. When used in a raw HTTP Query API, it
         * is formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param startTime
         *        The start of the time period that the returned information applies to. When used in a raw HTTP Query
         *        API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end of the time period that the returned information applies to. When used in a raw HTTP Query API, it is
         * formatted as be epoch time in seconds. For example: <code>1698778057</code>
         * </p>
         * <p>
         * This displays the time that Application Signals used for the request. It might not match your request
         * exactly, because it was rounded to the nearest hour.
         * </p>
         * 
         * @param endTime
         *        The end of the time period that the returned information applies to. When used in a raw HTTP Query
         *        API, it is formatted as be epoch time in seconds. For example: <code>1698778057</code> </p>
         *        <p>
         *        This displays the time that Application Signals used for the request. It might not match your request
         *        exactly, because it was rounded to the nearest hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * An array of structures, where each structure contains some information about a service. To get complete
         * information about a service, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html">GetService</a>.
         * </p>
         * 
         * @param serviceSummaries
         *        An array of structures, where each structure contains some information about a service. To get
         *        complete information about a service, use <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html"
         *        >GetService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSummaries(Collection<ServiceSummary> serviceSummaries);

        /**
         * <p>
         * An array of structures, where each structure contains some information about a service. To get complete
         * information about a service, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html">GetService</a>.
         * </p>
         * 
         * @param serviceSummaries
         *        An array of structures, where each structure contains some information about a service. To get
         *        complete information about a service, use <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html"
         *        >GetService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSummaries(ServiceSummary... serviceSummaries);

        /**
         * <p>
         * An array of structures, where each structure contains some information about a service. To get complete
         * information about a service, use <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetService.html">GetService</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.ServiceSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceSummaries(List<ServiceSummary>)}.
         * 
         * @param serviceSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.ServiceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSummaries(java.util.Collection<ServiceSummary>)
         */
        Builder serviceSummaries(Consumer<ServiceSummary.Builder>... serviceSummaries);

        /**
         * <p>
         * Include this value in your next use of this API to get next set of services.
         * </p>
         * 
         * @param nextToken
         *        Include this value in your next use of this API to get next set of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationSignalsResponse.BuilderImpl implements Builder {
        private Instant startTime;

        private Instant endTime;

        private List<ServiceSummary> serviceSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            startTime(model.startTime);
            endTime(model.endTime);
            serviceSummaries(model.serviceSummaries);
            nextToken(model.nextToken);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final List<ServiceSummary.Builder> getServiceSummaries() {
            List<ServiceSummary.Builder> result = ServiceSummariesCopier.copyToBuilder(this.serviceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceSummaries(Collection<ServiceSummary.BuilderImpl> serviceSummaries) {
            this.serviceSummaries = ServiceSummariesCopier.copyFromBuilder(serviceSummaries);
        }

        @Override
        public final Builder serviceSummaries(Collection<ServiceSummary> serviceSummaries) {
            this.serviceSummaries = ServiceSummariesCopier.copy(serviceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaries(ServiceSummary... serviceSummaries) {
            serviceSummaries(Arrays.asList(serviceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceSummaries(Consumer<ServiceSummary.Builder>... serviceSummaries) {
            serviceSummaries(Stream.of(serviceSummaries).map(c -> ServiceSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
