/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceLevelObjectiveRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<UpdateServiceLevelObjectiveRequest.Builder, UpdateServiceLevelObjectiveRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(UpdateServiceLevelObjectiveRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateServiceLevelObjectiveRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ServiceLevelIndicatorConfig> SLI_CONFIG_FIELD = SdkField
            .<ServiceLevelIndicatorConfig> builder(MarshallingType.SDK_POJO).memberName("SliConfig")
            .getter(getter(UpdateServiceLevelObjectiveRequest::sliConfig)).setter(setter(Builder::sliConfig))
            .constructor(ServiceLevelIndicatorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliConfig").build()).build();

    private static final SdkField<RequestBasedServiceLevelIndicatorConfig> REQUEST_BASED_SLI_CONFIG_FIELD = SdkField
            .<RequestBasedServiceLevelIndicatorConfig> builder(MarshallingType.SDK_POJO).memberName("RequestBasedSliConfig")
            .getter(getter(UpdateServiceLevelObjectiveRequest::requestBasedSliConfig))
            .setter(setter(Builder::requestBasedSliConfig)).constructor(RequestBasedServiceLevelIndicatorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliConfig").build())
            .build();

    private static final SdkField<Goal> GOAL_FIELD = SdkField.<Goal> builder(MarshallingType.SDK_POJO).memberName("Goal")
            .getter(getter(UpdateServiceLevelObjectiveRequest::goal)).setter(setter(Builder::goal)).constructor(Goal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Goal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            SLI_CONFIG_FIELD, REQUEST_BASED_SLI_CONFIG_FIELD, GOAL_FIELD));

    private final String id;

    private final String description;

    private final ServiceLevelIndicatorConfig sliConfig;

    private final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;

    private final Goal goal;

    private UpdateServiceLevelObjectiveRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.description = builder.description;
        this.sliConfig = builder.sliConfig;
        this.requestBasedSliConfig = builder.requestBasedSliConfig;
        this.goal = builder.goal;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or name of the service level objective that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or name of the service level objective that you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An optional description for the SLO.
     * </p>
     * 
     * @return An optional description for the SLO.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * If this SLO is a period-based SLO, this structure defines the information about what performance metric this SLO
     * will monitor.
     * </p>
     * 
     * @return If this SLO is a period-based SLO, this structure defines the information about what performance metric
     *         this SLO will monitor.
     */
    public final ServiceLevelIndicatorConfig sliConfig() {
        return sliConfig;
    }

    /**
     * <p>
     * If this SLO is a request-based SLO, this structure defines the information about what performance metric this SLO
     * will monitor.
     * </p>
     * <p>
     * You can't specify both <code>SliConfig</code> and <code>RequestBasedSliConfig</code> in the same operation.
     * </p>
     * 
     * @return If this SLO is a request-based SLO, this structure defines the information about what performance metric
     *         this SLO will monitor.</p>
     *         <p>
     *         You can't specify both <code>SliConfig</code> and <code>RequestBasedSliConfig</code> in the same
     *         operation.
     */
    public final RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig() {
        return requestBasedSliConfig;
    }

    /**
     * <p>
     * A structure that contains the attributes that determine the goal of the SLO. This includes the time period for
     * evaluation and the attainment threshold.
     * </p>
     * 
     * @return A structure that contains the attributes that determine the goal of the SLO. This includes the time
     *         period for evaluation and the attainment threshold.
     */
    public final Goal goal() {
        return goal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(requestBasedSliConfig());
        hashCode = 31 * hashCode + Objects.hashCode(goal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceLevelObjectiveRequest)) {
            return false;
        }
        UpdateServiceLevelObjectiveRequest other = (UpdateServiceLevelObjectiveRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(sliConfig(), other.sliConfig())
                && Objects.equals(requestBasedSliConfig(), other.requestBasedSliConfig()) && Objects.equals(goal(), other.goal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceLevelObjectiveRequest").add("Id", id()).add("Description", description())
                .add("SliConfig", sliConfig()).add("RequestBasedSliConfig", requestBasedSliConfig()).add("Goal", goal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SliConfig":
            return Optional.ofNullable(clazz.cast(sliConfig()));
        case "RequestBasedSliConfig":
            return Optional.ofNullable(clazz.cast(requestBasedSliConfig()));
        case "Goal":
            return Optional.ofNullable(clazz.cast(goal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceLevelObjectiveRequest, T> g) {
        return obj -> g.apply((UpdateServiceLevelObjectiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceLevelObjectiveRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or name of the service level objective that you want to update.
         * </p>
         * 
         * @param id
         *        The Amazon Resource Name (ARN) or name of the service level objective that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An optional description for the SLO.
         * </p>
         * 
         * @param description
         *        An optional description for the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * If this SLO is a period-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * 
         * @param sliConfig
         *        If this SLO is a period-based SLO, this structure defines the information about what performance
         *        metric this SLO will monitor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sliConfig(ServiceLevelIndicatorConfig sliConfig);

        /**
         * <p>
         * If this SLO is a period-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceLevelIndicatorConfig.Builder}
         * avoiding the need to create one manually via {@link ServiceLevelIndicatorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelIndicatorConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #sliConfig(ServiceLevelIndicatorConfig)}.
         * 
         * @param sliConfig
         *        a consumer that will call methods on {@link ServiceLevelIndicatorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sliConfig(ServiceLevelIndicatorConfig)
         */
        default Builder sliConfig(Consumer<ServiceLevelIndicatorConfig.Builder> sliConfig) {
            return sliConfig(ServiceLevelIndicatorConfig.builder().applyMutation(sliConfig).build());
        }

        /**
         * <p>
         * If this SLO is a request-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>SliConfig</code> and <code>RequestBasedSliConfig</code> in the same operation.
         * </p>
         * 
         * @param requestBasedSliConfig
         *        If this SLO is a request-based SLO, this structure defines the information about what performance
         *        metric this SLO will monitor.</p>
         *        <p>
         *        You can't specify both <code>SliConfig</code> and <code>RequestBasedSliConfig</code> in the same
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig);

        /**
         * <p>
         * If this SLO is a request-based SLO, this structure defines the information about what performance metric this
         * SLO will monitor.
         * </p>
         * <p>
         * You can't specify both <code>SliConfig</code> and <code>RequestBasedSliConfig</code> in the same operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RequestBasedServiceLevelIndicatorConfig.Builder} avoiding the need to create one manually via
         * {@link RequestBasedServiceLevelIndicatorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RequestBasedServiceLevelIndicatorConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig)}.
         * 
         * @param requestBasedSliConfig
         *        a consumer that will call methods on {@link RequestBasedServiceLevelIndicatorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig)
         */
        default Builder requestBasedSliConfig(Consumer<RequestBasedServiceLevelIndicatorConfig.Builder> requestBasedSliConfig) {
            return requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.builder().applyMutation(requestBasedSliConfig)
                    .build());
        }

        /**
         * <p>
         * A structure that contains the attributes that determine the goal of the SLO. This includes the time period
         * for evaluation and the attainment threshold.
         * </p>
         * 
         * @param goal
         *        A structure that contains the attributes that determine the goal of the SLO. This includes the time
         *        period for evaluation and the attainment threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder goal(Goal goal);

        /**
         * <p>
         * A structure that contains the attributes that determine the goal of the SLO. This includes the time period
         * for evaluation and the attainment threshold.
         * </p>
         * This is a convenience method that creates an instance of the {@link Goal.Builder} avoiding the need to create
         * one manually via {@link Goal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Goal.Builder#build()} is called immediately and its result is
         * passed to {@link #goal(Goal)}.
         * 
         * @param goal
         *        a consumer that will call methods on {@link Goal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #goal(Goal)
         */
        default Builder goal(Consumer<Goal.Builder> goal) {
            return goal(Goal.builder().applyMutation(goal).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private String id;

        private String description;

        private ServiceLevelIndicatorConfig sliConfig;

        private RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig;

        private Goal goal;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceLevelObjectiveRequest model) {
            super(model);
            id(model.id);
            description(model.description);
            sliConfig(model.sliConfig);
            requestBasedSliConfig(model.requestBasedSliConfig);
            goal(model.goal);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ServiceLevelIndicatorConfig.Builder getSliConfig() {
            return sliConfig != null ? sliConfig.toBuilder() : null;
        }

        public final void setSliConfig(ServiceLevelIndicatorConfig.BuilderImpl sliConfig) {
            this.sliConfig = sliConfig != null ? sliConfig.build() : null;
        }

        @Override
        public final Builder sliConfig(ServiceLevelIndicatorConfig sliConfig) {
            this.sliConfig = sliConfig;
            return this;
        }

        public final RequestBasedServiceLevelIndicatorConfig.Builder getRequestBasedSliConfig() {
            return requestBasedSliConfig != null ? requestBasedSliConfig.toBuilder() : null;
        }

        public final void setRequestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig.BuilderImpl requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig != null ? requestBasedSliConfig.build() : null;
        }

        @Override
        public final Builder requestBasedSliConfig(RequestBasedServiceLevelIndicatorConfig requestBasedSliConfig) {
            this.requestBasedSliConfig = requestBasedSliConfig;
            return this;
        }

        public final Goal.Builder getGoal() {
            return goal != null ? goal.toBuilder() : null;
        }

        public final void setGoal(Goal.BuilderImpl goal) {
            this.goal = goal != null ? goal.build() : null;
        }

        @Override
        public final Builder goal(Goal goal) {
            this.goal = goal;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceLevelObjectiveRequest build() {
            return new UpdateServiceLevelObjectiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
