/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure contains information about one dependency of this service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceDependency implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceDependency.Builder, ServiceDependency> {
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(ServiceDependency::operationName)).setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationName").build()).build();

    private static final SdkField<Map<String, String>> DEPENDENCY_KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DependencyKeyAttributes")
            .getter(getter(ServiceDependency::dependencyKeyAttributes))
            .setter(setter(Builder::dependencyKeyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyKeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> DEPENDENCY_OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DependencyOperationName").getter(getter(ServiceDependency::dependencyOperationName))
            .setter(setter(Builder::dependencyOperationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependencyOperationName").build())
            .build();

    private static final SdkField<List<MetricReference>> METRIC_REFERENCES_FIELD = SdkField
            .<List<MetricReference>> builder(MarshallingType.LIST)
            .memberName("MetricReferences")
            .getter(getter(ServiceDependency::metricReferences))
            .setter(setter(Builder::metricReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_NAME_FIELD,
            DEPENDENCY_KEY_ATTRIBUTES_FIELD, DEPENDENCY_OPERATION_NAME_FIELD, METRIC_REFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operationName;

    private final Map<String, String> dependencyKeyAttributes;

    private final String dependencyOperationName;

    private final List<MetricReference> metricReferences;

    private ServiceDependency(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.dependencyKeyAttributes = builder.dependencyKeyAttributes;
        this.dependencyOperationName = builder.dependencyOperationName;
        this.metricReferences = builder.metricReferences;
    }

    /**
     * <p>
     * The name of the operation in this service that calls the dependency.
     * </p>
     * 
     * @return The name of the operation in this service that calls the dependency.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DependencyKeyAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDependencyKeyAttributes() {
        return dependencyKeyAttributes != null && !(dependencyKeyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencyKeyAttributes} method.
     * </p>
     * 
     * @return This is a string-to-string map. It can include the following fields.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> dependencyKeyAttributes() {
        return dependencyKeyAttributes;
    }

    /**
     * <p>
     * The name of the called operation in the dependency.
     * </p>
     * 
     * @return The name of the called operation in the dependency.
     */
    public final String dependencyOperationName() {
        return dependencyOperationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricReferences() {
        return metricReferences != null && !(metricReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of structures that each contain information about one metric associated with this service dependency
     * that was discovered by Application Signals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricReferences} method.
     * </p>
     * 
     * @return An array of structures that each contain information about one metric associated with this service
     *         dependency that was discovered by Application Signals.
     */
    public final List<MetricReference> metricReferences() {
        return metricReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencyKeyAttributes() ? dependencyKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dependencyOperationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricReferences() ? metricReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceDependency)) {
            return false;
        }
        ServiceDependency other = (ServiceDependency) obj;
        return Objects.equals(operationName(), other.operationName())
                && hasDependencyKeyAttributes() == other.hasDependencyKeyAttributes()
                && Objects.equals(dependencyKeyAttributes(), other.dependencyKeyAttributes())
                && Objects.equals(dependencyOperationName(), other.dependencyOperationName())
                && hasMetricReferences() == other.hasMetricReferences()
                && Objects.equals(metricReferences(), other.metricReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceDependency").add("OperationName", operationName())
                .add("DependencyKeyAttributes", hasDependencyKeyAttributes() ? dependencyKeyAttributes() : null)
                .add("DependencyOperationName", dependencyOperationName())
                .add("MetricReferences", hasMetricReferences() ? metricReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "DependencyKeyAttributes":
            return Optional.ofNullable(clazz.cast(dependencyKeyAttributes()));
        case "DependencyOperationName":
            return Optional.ofNullable(clazz.cast(dependencyOperationName()));
        case "MetricReferences":
            return Optional.ofNullable(clazz.cast(metricReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceDependency, T> g) {
        return obj -> g.apply((ServiceDependency) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceDependency> {
        /**
         * <p>
         * The name of the operation in this service that calls the dependency.
         * </p>
         * 
         * @param operationName
         *        The name of the operation in this service that calls the dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dependencyKeyAttributes
         *        This is a string-to-string map. It can include the following fields.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes);

        /**
         * <p>
         * The name of the called operation in the dependency.
         * </p>
         * 
         * @param dependencyOperationName
         *        The name of the called operation in the dependency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencyOperationName(String dependencyOperationName);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service dependency
         * that was discovered by Application Signals.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service
         *        dependency that was discovered by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(Collection<MetricReference> metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service dependency
         * that was discovered by Application Signals.
         * </p>
         * 
         * @param metricReferences
         *        An array of structures that each contain information about one metric associated with this service
         *        dependency that was discovered by Application Signals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricReferences(MetricReference... metricReferences);

        /**
         * <p>
         * An array of structures that each contain information about one metric associated with this service dependency
         * that was discovered by Application Signals.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder#build()} is called
         * immediately and its result is passed to {@link #metricReferences(List<MetricReference>)}.
         * 
         * @param metricReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationsignals.model.MetricReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricReferences(java.util.Collection<MetricReference>)
         */
        Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences);
    }

    static final class BuilderImpl implements Builder {
        private String operationName;

        private Map<String, String> dependencyKeyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String dependencyOperationName;

        private List<MetricReference> metricReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceDependency model) {
            operationName(model.operationName);
            dependencyKeyAttributes(model.dependencyKeyAttributes);
            dependencyOperationName(model.dependencyOperationName);
            metricReferences(model.metricReferences);
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Map<String, String> getDependencyKeyAttributes() {
            if (dependencyKeyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return dependencyKeyAttributes;
        }

        public final void setDependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
        }

        @Override
        public final Builder dependencyKeyAttributes(Map<String, String> dependencyKeyAttributes) {
            this.dependencyKeyAttributes = AttributesCopier.copy(dependencyKeyAttributes);
            return this;
        }

        public final String getDependencyOperationName() {
            return dependencyOperationName;
        }

        public final void setDependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
        }

        @Override
        public final Builder dependencyOperationName(String dependencyOperationName) {
            this.dependencyOperationName = dependencyOperationName;
            return this;
        }

        public final List<MetricReference.Builder> getMetricReferences() {
            List<MetricReference.Builder> result = MetricReferencesCopier.copyToBuilder(this.metricReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricReferences(Collection<MetricReference.BuilderImpl> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copyFromBuilder(metricReferences);
        }

        @Override
        public final Builder metricReferences(Collection<MetricReference> metricReferences) {
            this.metricReferences = MetricReferencesCopier.copy(metricReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(MetricReference... metricReferences) {
            metricReferences(Arrays.asList(metricReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricReferences(Consumer<MetricReference.Builder>... metricReferences) {
            metricReferences(Stream.of(metricReferences).map(c -> MetricReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceDependency build() {
            return new ServiceDependency(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
