/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This structure specifies the information about the service and the performance metric that a period-based SLO is to
 * monitor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceLevelIndicatorConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceLevelIndicatorConfig.Builder, ServiceLevelIndicatorConfig> {
    private static final SdkField<ServiceLevelIndicatorMetricConfig> SLI_METRIC_CONFIG_FIELD = SdkField
            .<ServiceLevelIndicatorMetricConfig> builder(MarshallingType.SDK_POJO).memberName("SliMetricConfig")
            .getter(getter(ServiceLevelIndicatorConfig::sliMetricConfig)).setter(setter(Builder::sliMetricConfig))
            .constructor(ServiceLevelIndicatorMetricConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliMetricConfig").build()).build();

    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MetricThreshold").getter(getter(ServiceLevelIndicatorConfig::metricThreshold))
            .setter(setter(Builder::metricThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()).build();

    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(ServiceLevelIndicatorConfig::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLI_METRIC_CONFIG_FIELD,
            METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceLevelIndicatorMetricConfig sliMetricConfig;

    private final Double metricThreshold;

    private final String comparisonOperator;

    private ServiceLevelIndicatorConfig(BuilderImpl builder) {
        this.sliMetricConfig = builder.sliMetricConfig;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    /**
     * <p>
     * Use this structure to specify the metric to be used for the SLO.
     * </p>
     * 
     * @return Use this structure to specify the metric to be used for the SLO.
     */
    public final ServiceLevelIndicatorMetricConfig sliMetricConfig() {
        return sliMetricConfig;
    }

    /**
     * <p>
     * This parameter is used only when a request-based SLO tracks the <code>Latency</code> metric. Specify the
     * threshold value that the observed <code>Latency</code> metric values are to be compared to.
     * </p>
     * 
     * @return This parameter is used only when a request-based SLO tracks the <code>Latency</code> metric. Specify the
     *         threshold value that the observed <code>Latency</code> metric values are to be compared to.
     */
    public final Double metricThreshold() {
        return metricThreshold;
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified metric to the threshold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ServiceLevelIndicatorComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified metric to the threshold.
     * @see ServiceLevelIndicatorComparisonOperator
     */
    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * The arithmetic operation to use when comparing the specified metric to the threshold.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ServiceLevelIndicatorComparisonOperator#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return The arithmetic operation to use when comparing the specified metric to the threshold.
     * @see ServiceLevelIndicatorComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sliMetricConfig());
        hashCode = 31 * hashCode + Objects.hashCode(metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicatorConfig)) {
            return false;
        }
        ServiceLevelIndicatorConfig other = (ServiceLevelIndicatorConfig) obj;
        return Objects.equals(sliMetricConfig(), other.sliMetricConfig())
                && Objects.equals(metricThreshold(), other.metricThreshold())
                && Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceLevelIndicatorConfig").add("SliMetricConfig", sliMetricConfig())
                .add("MetricThreshold", metricThreshold()).add("ComparisonOperator", comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SliMetricConfig":
            return Optional.ofNullable(clazz.cast(sliMetricConfig()));
        case "MetricThreshold":
            return Optional.ofNullable(clazz.cast(metricThreshold()));
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicatorConfig, T> g) {
        return obj -> g.apply((ServiceLevelIndicatorConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceLevelIndicatorConfig> {
        /**
         * <p>
         * Use this structure to specify the metric to be used for the SLO.
         * </p>
         * 
         * @param sliMetricConfig
         *        Use this structure to specify the metric to be used for the SLO.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sliMetricConfig(ServiceLevelIndicatorMetricConfig sliMetricConfig);

        /**
         * <p>
         * Use this structure to specify the metric to be used for the SLO.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceLevelIndicatorMetricConfig.Builder} avoiding the need to create one manually via
         * {@link ServiceLevelIndicatorMetricConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceLevelIndicatorMetricConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #sliMetricConfig(ServiceLevelIndicatorMetricConfig)}.
         * 
         * @param sliMetricConfig
         *        a consumer that will call methods on {@link ServiceLevelIndicatorMetricConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sliMetricConfig(ServiceLevelIndicatorMetricConfig)
         */
        default Builder sliMetricConfig(Consumer<ServiceLevelIndicatorMetricConfig.Builder> sliMetricConfig) {
            return sliMetricConfig(ServiceLevelIndicatorMetricConfig.builder().applyMutation(sliMetricConfig).build());
        }

        /**
         * <p>
         * This parameter is used only when a request-based SLO tracks the <code>Latency</code> metric. Specify the
         * threshold value that the observed <code>Latency</code> metric values are to be compared to.
         * </p>
         * 
         * @param metricThreshold
         *        This parameter is used only when a request-based SLO tracks the <code>Latency</code> metric. Specify
         *        the threshold value that the observed <code>Latency</code> metric values are to be compared to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricThreshold(Double metricThreshold);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified metric to the threshold.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified metric to the threshold.
         * @see ServiceLevelIndicatorComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * The arithmetic operation to use when comparing the specified metric to the threshold.
         * </p>
         * 
         * @param comparisonOperator
         *        The arithmetic operation to use when comparing the specified metric to the threshold.
         * @see ServiceLevelIndicatorComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceLevelIndicatorComparisonOperator
         */
        Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator);
    }

    static final class BuilderImpl implements Builder {
        private ServiceLevelIndicatorMetricConfig sliMetricConfig;

        private Double metricThreshold;

        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicatorConfig model) {
            sliMetricConfig(model.sliMetricConfig);
            metricThreshold(model.metricThreshold);
            comparisonOperator(model.comparisonOperator);
        }

        public final ServiceLevelIndicatorMetricConfig.Builder getSliMetricConfig() {
            return sliMetricConfig != null ? sliMetricConfig.toBuilder() : null;
        }

        public final void setSliMetricConfig(ServiceLevelIndicatorMetricConfig.BuilderImpl sliMetricConfig) {
            this.sliMetricConfig = sliMetricConfig != null ? sliMetricConfig.build() : null;
        }

        @Override
        public final Builder sliMetricConfig(ServiceLevelIndicatorMetricConfig sliMetricConfig) {
            this.sliMetricConfig = sliMetricConfig;
            return this;
        }

        public final Double getMetricThreshold() {
            return metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        @Override
        public ServiceLevelIndicatorConfig build() {
            return new ServiceLevelIndicatorConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
