/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationsignals.model.ApplicationSignalsResponse;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReport;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportError;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportErrorsCopier;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelObjectiveBudgetReportsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetServiceLevelObjectiveBudgetReportResponse
extends ApplicationSignalsResponse
implements ToCopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportResponse> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(BatchGetServiceLevelObjectiveBudgetReportResponse.getter(BatchGetServiceLevelObjectiveBudgetReportResponse::timestamp)).setter(BatchGetServiceLevelObjectiveBudgetReportResponse.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<List<ServiceLevelObjectiveBudgetReport>> REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Reports").getter(BatchGetServiceLevelObjectiveBudgetReportResponse.getter(BatchGetServiceLevelObjectiveBudgetReportResponse::reports)).setter(BatchGetServiceLevelObjectiveBudgetReportResponse.setter(Builder::reports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceLevelObjectiveBudgetReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceLevelObjectiveBudgetReportError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetServiceLevelObjectiveBudgetReportResponse.getter(BatchGetServiceLevelObjectiveBudgetReportResponse::errors)).setter(BatchGetServiceLevelObjectiveBudgetReportResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceLevelObjectiveBudgetReportError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, REPORTS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Timestamp", TIMESTAMP_FIELD);
            this.put("Reports", REPORTS_FIELD);
            this.put("Errors", ERRORS_FIELD);
        }
    });
    private final Instant timestamp;
    private final List<ServiceLevelObjectiveBudgetReport> reports;
    private final List<ServiceLevelObjectiveBudgetReportError> errors;

    private BatchGetServiceLevelObjectiveBudgetReportResponse(BuilderImpl builder) {
        super(builder);
        this.timestamp = builder.timestamp;
        this.reports = builder.reports;
        this.errors = builder.errors;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final boolean hasReports() {
        return this.reports != null && !(this.reports instanceof SdkAutoConstructList);
    }

    public final List<ServiceLevelObjectiveBudgetReport> reports() {
        return this.reports;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<ServiceLevelObjectiveBudgetReportError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReports() ? this.reports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetServiceLevelObjectiveBudgetReportResponse)) {
            return false;
        }
        BatchGetServiceLevelObjectiveBudgetReportResponse other = (BatchGetServiceLevelObjectiveBudgetReportResponse)((Object)obj);
        return Objects.equals(this.timestamp(), other.timestamp()) && this.hasReports() == other.hasReports() && Objects.equals(this.reports(), other.reports()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetServiceLevelObjectiveBudgetReportResponse").add("Timestamp", (Object)this.timestamp()).add("Reports", this.hasReports() ? this.reports() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Reports": {
                return Optional.ofNullable(clazz.cast(this.reports()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetServiceLevelObjectiveBudgetReportResponse, T> g) {
        return obj -> g.apply((BatchGetServiceLevelObjectiveBudgetReportResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationSignalsResponse.BuilderImpl
    implements Builder {
        private Instant timestamp;
        private List<ServiceLevelObjectiveBudgetReport> reports = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceLevelObjectiveBudgetReportError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetServiceLevelObjectiveBudgetReportResponse model) {
            super(model);
            this.timestamp(model.timestamp);
            this.reports(model.reports);
            this.errors(model.errors);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<ServiceLevelObjectiveBudgetReport.Builder> getReports() {
            List<ServiceLevelObjectiveBudgetReport.Builder> result = ServiceLevelObjectiveBudgetReportsCopier.copyToBuilder(this.reports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReports(Collection<ServiceLevelObjectiveBudgetReport.BuilderImpl> reports) {
            this.reports = ServiceLevelObjectiveBudgetReportsCopier.copyFromBuilder(reports);
        }

        @Override
        public final Builder reports(Collection<ServiceLevelObjectiveBudgetReport> reports) {
            this.reports = ServiceLevelObjectiveBudgetReportsCopier.copy(reports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(ServiceLevelObjectiveBudgetReport ... reports) {
            this.reports(Arrays.asList(reports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reports(Consumer<ServiceLevelObjectiveBudgetReport.Builder> ... reports) {
            this.reports(Stream.of(reports).map(c -> (ServiceLevelObjectiveBudgetReport)((ServiceLevelObjectiveBudgetReport.Builder)ServiceLevelObjectiveBudgetReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceLevelObjectiveBudgetReportError.Builder> getErrors() {
            List<ServiceLevelObjectiveBudgetReportError.Builder> result = ServiceLevelObjectiveBudgetReportErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<ServiceLevelObjectiveBudgetReportError.BuilderImpl> errors) {
            this.errors = ServiceLevelObjectiveBudgetReportErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<ServiceLevelObjectiveBudgetReportError> errors) {
            this.errors = ServiceLevelObjectiveBudgetReportErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(ServiceLevelObjectiveBudgetReportError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<ServiceLevelObjectiveBudgetReportError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (ServiceLevelObjectiveBudgetReportError)((ServiceLevelObjectiveBudgetReportError.Builder)ServiceLevelObjectiveBudgetReportError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetServiceLevelObjectiveBudgetReportResponse build() {
            return new BatchGetServiceLevelObjectiveBudgetReportResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationSignalsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetServiceLevelObjectiveBudgetReportResponse> {
        public Builder timestamp(Instant var1);

        public Builder reports(Collection<ServiceLevelObjectiveBudgetReport> var1);

        public Builder reports(ServiceLevelObjectiveBudgetReport ... var1);

        public Builder reports(Consumer<ServiceLevelObjectiveBudgetReport.Builder> ... var1);

        public Builder errors(Collection<ServiceLevelObjectiveBudgetReportError> var1);

        public Builder errors(ServiceLevelObjectiveBudgetReportError ... var1);

        public Builder errors(Consumer<ServiceLevelObjectiveBudgetReportError.Builder> ... var1);
    }
}

