/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.RequestBasedServiceLevelIndicatorMetric;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorComparisonOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestBasedServiceLevelIndicator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestBasedServiceLevelIndicator> {
    private static final SdkField<RequestBasedServiceLevelIndicatorMetric> REQUEST_BASED_SLI_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestBasedSliMetric").getter(RequestBasedServiceLevelIndicator.getter(RequestBasedServiceLevelIndicator::requestBasedSliMetric)).setter(RequestBasedServiceLevelIndicator.setter(Builder::requestBasedSliMetric)).constructor(RequestBasedServiceLevelIndicatorMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestBasedSliMetric").build()}).build();
    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricThreshold").getter(RequestBasedServiceLevelIndicator.getter(RequestBasedServiceLevelIndicator::metricThreshold)).setter(RequestBasedServiceLevelIndicator.setter(Builder::metricThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(RequestBasedServiceLevelIndicator.getter(RequestBasedServiceLevelIndicator::comparisonOperatorAsString)).setter(RequestBasedServiceLevelIndicator.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_BASED_SLI_METRIC_FIELD, METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RequestBasedSliMetric", REQUEST_BASED_SLI_METRIC_FIELD);
            this.put("MetricThreshold", METRIC_THRESHOLD_FIELD);
            this.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RequestBasedServiceLevelIndicatorMetric requestBasedSliMetric;
    private final Double metricThreshold;
    private final String comparisonOperator;

    private RequestBasedServiceLevelIndicator(BuilderImpl builder) {
        this.requestBasedSliMetric = builder.requestBasedSliMetric;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public final RequestBasedServiceLevelIndicatorMetric requestBasedSliMetric() {
        return this.requestBasedSliMetric;
    }

    public final Double metricThreshold() {
        return this.metricThreshold;
    }

    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestBasedSliMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestBasedServiceLevelIndicator)) {
            return false;
        }
        RequestBasedServiceLevelIndicator other = (RequestBasedServiceLevelIndicator)obj;
        return Objects.equals(this.requestBasedSliMetric(), other.requestBasedSliMetric()) && Objects.equals(this.metricThreshold(), other.metricThreshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RequestBasedServiceLevelIndicator").add("RequestBasedSliMetric", (Object)this.requestBasedSliMetric()).add("MetricThreshold", (Object)this.metricThreshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestBasedSliMetric": {
                return Optional.ofNullable(clazz.cast(this.requestBasedSliMetric()));
            }
            case "MetricThreshold": {
                return Optional.ofNullable(clazz.cast(this.metricThreshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestBasedServiceLevelIndicator, T> g) {
        return obj -> g.apply((RequestBasedServiceLevelIndicator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RequestBasedServiceLevelIndicatorMetric requestBasedSliMetric;
        private Double metricThreshold;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestBasedServiceLevelIndicator model) {
            this.requestBasedSliMetric(model.requestBasedSliMetric);
            this.metricThreshold(model.metricThreshold);
            this.comparisonOperator(model.comparisonOperator);
        }

        public final RequestBasedServiceLevelIndicatorMetric.Builder getRequestBasedSliMetric() {
            return this.requestBasedSliMetric != null ? this.requestBasedSliMetric.toBuilder() : null;
        }

        public final void setRequestBasedSliMetric(RequestBasedServiceLevelIndicatorMetric.BuilderImpl requestBasedSliMetric) {
            this.requestBasedSliMetric = requestBasedSliMetric != null ? requestBasedSliMetric.build() : null;
        }

        @Override
        public final Builder requestBasedSliMetric(RequestBasedServiceLevelIndicatorMetric requestBasedSliMetric) {
            this.requestBasedSliMetric = requestBasedSliMetric;
            return this;
        }

        public final Double getMetricThreshold() {
            return this.metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public RequestBasedServiceLevelIndicator build() {
            return new RequestBasedServiceLevelIndicator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestBasedServiceLevelIndicator> {
        public Builder requestBasedSliMetric(RequestBasedServiceLevelIndicatorMetric var1);

        default public Builder requestBasedSliMetric(Consumer<RequestBasedServiceLevelIndicatorMetric.Builder> requestBasedSliMetric) {
            return this.requestBasedSliMetric((RequestBasedServiceLevelIndicatorMetric)((RequestBasedServiceLevelIndicatorMetric.Builder)RequestBasedServiceLevelIndicatorMetric.builder().applyMutation(requestBasedSliMetric)).build());
        }

        public Builder metricThreshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator var1);
    }
}

