/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorComparisonOperator;
import software.amazon.awssdk.services.applicationsignals.model.ServiceLevelIndicatorMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceLevelIndicator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceLevelIndicator> {
    private static final SdkField<ServiceLevelIndicatorMetric> SLI_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SliMetric").getter(ServiceLevelIndicator.getter(ServiceLevelIndicator::sliMetric)).setter(ServiceLevelIndicator.setter(Builder::sliMetric)).constructor(ServiceLevelIndicatorMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SliMetric").build()}).build();
    private static final SdkField<Double> METRIC_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MetricThreshold").getter(ServiceLevelIndicator.getter(ServiceLevelIndicator::metricThreshold)).setter(ServiceLevelIndicator.setter(Builder::metricThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricThreshold").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComparisonOperator").getter(ServiceLevelIndicator.getter(ServiceLevelIndicator::comparisonOperatorAsString)).setter(ServiceLevelIndicator.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLI_METRIC_FIELD, METRIC_THRESHOLD_FIELD, COMPARISON_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SliMetric", SLI_METRIC_FIELD);
            this.put("MetricThreshold", METRIC_THRESHOLD_FIELD);
            this.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ServiceLevelIndicatorMetric sliMetric;
    private final Double metricThreshold;
    private final String comparisonOperator;

    private ServiceLevelIndicator(BuilderImpl builder) {
        this.sliMetric = builder.sliMetric;
        this.metricThreshold = builder.metricThreshold;
        this.comparisonOperator = builder.comparisonOperator;
    }

    public final ServiceLevelIndicatorMetric sliMetric() {
        return this.sliMetric;
    }

    public final Double metricThreshold() {
        return this.metricThreshold;
    }

    public final ServiceLevelIndicatorComparisonOperator comparisonOperator() {
        return ServiceLevelIndicatorComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sliMetric());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceLevelIndicator)) {
            return false;
        }
        ServiceLevelIndicator other = (ServiceLevelIndicator)obj;
        return Objects.equals(this.sliMetric(), other.sliMetric()) && Objects.equals(this.metricThreshold(), other.metricThreshold()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceLevelIndicator").add("SliMetric", (Object)this.sliMetric()).add("MetricThreshold", (Object)this.metricThreshold()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SliMetric": {
                return Optional.ofNullable(clazz.cast(this.sliMetric()));
            }
            case "MetricThreshold": {
                return Optional.ofNullable(clazz.cast(this.metricThreshold()));
            }
            case "ComparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ServiceLevelIndicator, T> g) {
        return obj -> g.apply((ServiceLevelIndicator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceLevelIndicatorMetric sliMetric;
        private Double metricThreshold;
        private String comparisonOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceLevelIndicator model) {
            this.sliMetric(model.sliMetric);
            this.metricThreshold(model.metricThreshold);
            this.comparisonOperator(model.comparisonOperator);
        }

        public final ServiceLevelIndicatorMetric.Builder getSliMetric() {
            return this.sliMetric != null ? this.sliMetric.toBuilder() : null;
        }

        public final void setSliMetric(ServiceLevelIndicatorMetric.BuilderImpl sliMetric) {
            this.sliMetric = sliMetric != null ? sliMetric.build() : null;
        }

        @Override
        public final Builder sliMetric(ServiceLevelIndicatorMetric sliMetric) {
            this.sliMetric = sliMetric;
            return this;
        }

        public final Double getMetricThreshold() {
            return this.metricThreshold;
        }

        public final void setMetricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
        }

        @Override
        public final Builder metricThreshold(Double metricThreshold) {
            this.metricThreshold = metricThreshold;
            return this;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public ServiceLevelIndicator build() {
            return new ServiceLevelIndicator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceLevelIndicator> {
        public Builder sliMetric(ServiceLevelIndicatorMetric var1);

        default public Builder sliMetric(Consumer<ServiceLevelIndicatorMetric.Builder> sliMetric) {
            return this.sliMetric((ServiceLevelIndicatorMetric)((ServiceLevelIndicatorMetric.Builder)ServiceLevelIndicatorMetric.builder().applyMutation(sliMetric)).build());
        }

        public Builder metricThreshold(Double var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ServiceLevelIndicatorComparisonOperator var1);
    }
}

