/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This object defines the length of the look-back window used to calculate one burn rate metric for this SLO. The burn
 * rate measures how fast the service is consuming the error budget, relative to the attainment goal of the SLO. A burn
 * rate of exactly 1 indicates that the SLO goal will be met exactly.
 * </p>
 * <p>
 * For example, if you specify 60 as the number of minutes in the look-back window, the burn rate is calculated as the
 * following:
 * </p>
 * <p>
 * <i>burn rate = error rate over the look-back window / (1 - attainment goal percentage)</i>
 * </p>
 * <p>
 * For more information about burn rates, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-ServiceLevelObjectives.html#CloudWatch-ServiceLevelObjectives-burn"
 * >Calculate burn rates</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BurnRateConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BurnRateConfiguration.Builder, BurnRateConfiguration> {
    private static final SdkField<Integer> LOOK_BACK_WINDOW_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("LookBackWindowMinutes").getter(getter(BurnRateConfiguration::lookBackWindowMinutes))
            .setter(setter(Builder::lookBackWindowMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookBackWindowMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOOK_BACK_WINDOW_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer lookBackWindowMinutes;

    private BurnRateConfiguration(BuilderImpl builder) {
        this.lookBackWindowMinutes = builder.lookBackWindowMinutes;
    }

    /**
     * <p>
     * The number of minutes to use as the look-back window.
     * </p>
     * 
     * @return The number of minutes to use as the look-back window.
     */
    public final Integer lookBackWindowMinutes() {
        return lookBackWindowMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lookBackWindowMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BurnRateConfiguration)) {
            return false;
        }
        BurnRateConfiguration other = (BurnRateConfiguration) obj;
        return Objects.equals(lookBackWindowMinutes(), other.lookBackWindowMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BurnRateConfiguration").add("LookBackWindowMinutes", lookBackWindowMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LookBackWindowMinutes":
            return Optional.ofNullable(clazz.cast(lookBackWindowMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LookBackWindowMinutes", LOOK_BACK_WINDOW_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BurnRateConfiguration, T> g) {
        return obj -> g.apply((BurnRateConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BurnRateConfiguration> {
        /**
         * <p>
         * The number of minutes to use as the look-back window.
         * </p>
         * 
         * @param lookBackWindowMinutes
         *        The number of minutes to use as the look-back window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookBackWindowMinutes(Integer lookBackWindowMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Integer lookBackWindowMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BurnRateConfiguration model) {
            lookBackWindowMinutes(model.lookBackWindowMinutes);
        }

        public final Integer getLookBackWindowMinutes() {
            return lookBackWindowMinutes;
        }

        public final void setLookBackWindowMinutes(Integer lookBackWindowMinutes) {
            this.lookBackWindowMinutes = lookBackWindowMinutes;
        }

        @Override
        public final Builder lookBackWindowMinutes(Integer lookBackWindowMinutes) {
            this.lookBackWindowMinutes = lookBackWindowMinutes;
            return this;
        }

        @Override
        public BurnRateConfiguration build() {
            return new BurnRateConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
