/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time period used to evaluate the SLO. It can be either a calendar interval or rolling interval.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Interval implements SdkPojo, Serializable, ToCopyableBuilder<Interval.Builder, Interval> {
    private static final SdkField<RollingInterval> ROLLING_INTERVAL_FIELD = SdkField
            .<RollingInterval> builder(MarshallingType.SDK_POJO).memberName("RollingInterval")
            .getter(getter(Interval::rollingInterval)).setter(setter(Builder::rollingInterval))
            .constructor(RollingInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingInterval").build()).build();

    private static final SdkField<CalendarInterval> CALENDAR_INTERVAL_FIELD = SdkField
            .<CalendarInterval> builder(MarshallingType.SDK_POJO).memberName("CalendarInterval")
            .getter(getter(Interval::calendarInterval)).setter(setter(Builder::calendarInterval))
            .constructor(CalendarInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarInterval").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_INTERVAL_FIELD,
            CALENDAR_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RollingInterval rollingInterval;

    private final CalendarInterval calendarInterval;

    private final Type type;

    private Interval(BuilderImpl builder) {
        this.rollingInterval = builder.rollingInterval;
        this.calendarInterval = builder.calendarInterval;
        this.type = builder.type;
    }

    /**
     * <p>
     * If the interval is a rolling interval, this structure contains the interval specifications.
     * </p>
     * 
     * @return If the interval is a rolling interval, this structure contains the interval specifications.
     */
    public final RollingInterval rollingInterval() {
        return rollingInterval;
    }

    /**
     * <p>
     * If the interval is a calendar interval, this structure contains the interval specifications.
     * </p>
     * 
     * @return If the interval is a calendar interval, this structure contains the interval specifications.
     */
    public final CalendarInterval calendarInterval() {
        return calendarInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollingInterval());
        hashCode = 31 * hashCode + Objects.hashCode(calendarInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval) obj;
        return Objects.equals(rollingInterval(), other.rollingInterval())
                && Objects.equals(calendarInterval(), other.calendarInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Interval").add("RollingInterval", rollingInterval()).add("CalendarInterval", calendarInterval())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollingInterval":
            return Optional.ofNullable(clazz.cast(rollingInterval()));
        case "CalendarInterval":
            return Optional.ofNullable(clazz.cast(calendarInterval()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #rollingInterval()} initialized to the given value.
     *
     * <p>
     * If the interval is a rolling interval, this structure contains the interval specifications.
     * </p>
     * 
     * @param rollingInterval
     *        If the interval is a rolling interval, this structure contains the interval specifications.
     */
    public static Interval fromRollingInterval(RollingInterval rollingInterval) {
        return builder().rollingInterval(rollingInterval).build();
    }

    /**
     * Create an instance of this class with {@link #rollingInterval()} initialized to the given value.
     *
     * <p>
     * If the interval is a rolling interval, this structure contains the interval specifications.
     * </p>
     * 
     * @param rollingInterval
     *        If the interval is a rolling interval, this structure contains the interval specifications.
     */
    public static Interval fromRollingInterval(Consumer<RollingInterval.Builder> rollingInterval) {
        RollingInterval.Builder builder = RollingInterval.builder();
        rollingInterval.accept(builder);
        return fromRollingInterval(builder.build());
    }

    /**
     * Create an instance of this class with {@link #calendarInterval()} initialized to the given value.
     *
     * <p>
     * If the interval is a calendar interval, this structure contains the interval specifications.
     * </p>
     * 
     * @param calendarInterval
     *        If the interval is a calendar interval, this structure contains the interval specifications.
     */
    public static Interval fromCalendarInterval(CalendarInterval calendarInterval) {
        return builder().calendarInterval(calendarInterval).build();
    }

    /**
     * Create an instance of this class with {@link #calendarInterval()} initialized to the given value.
     *
     * <p>
     * If the interval is a calendar interval, this structure contains the interval specifications.
     * </p>
     * 
     * @param calendarInterval
     *        If the interval is a calendar interval, this structure contains the interval specifications.
     */
    public static Interval fromCalendarInterval(Consumer<CalendarInterval.Builder> calendarInterval) {
        CalendarInterval.Builder builder = CalendarInterval.builder();
        calendarInterval.accept(builder);
        return fromCalendarInterval(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RollingInterval", ROLLING_INTERVAL_FIELD);
        map.put("CalendarInterval", CALENDAR_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Interval, T> g) {
        return obj -> g.apply((Interval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Interval> {
        /**
         * <p>
         * If the interval is a rolling interval, this structure contains the interval specifications.
         * </p>
         * 
         * @param rollingInterval
         *        If the interval is a rolling interval, this structure contains the interval specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingInterval(RollingInterval rollingInterval);

        /**
         * <p>
         * If the interval is a rolling interval, this structure contains the interval specifications.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollingInterval.Builder} avoiding the
         * need to create one manually via {@link RollingInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollingInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #rollingInterval(RollingInterval)}.
         * 
         * @param rollingInterval
         *        a consumer that will call methods on {@link RollingInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingInterval(RollingInterval)
         */
        default Builder rollingInterval(Consumer<RollingInterval.Builder> rollingInterval) {
            return rollingInterval(RollingInterval.builder().applyMutation(rollingInterval).build());
        }

        /**
         * <p>
         * If the interval is a calendar interval, this structure contains the interval specifications.
         * </p>
         * 
         * @param calendarInterval
         *        If the interval is a calendar interval, this structure contains the interval specifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarInterval(CalendarInterval calendarInterval);

        /**
         * <p>
         * If the interval is a calendar interval, this structure contains the interval specifications.
         * </p>
         * This is a convenience method that creates an instance of the {@link CalendarInterval.Builder} avoiding the
         * need to create one manually via {@link CalendarInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CalendarInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #calendarInterval(CalendarInterval)}.
         * 
         * @param calendarInterval
         *        a consumer that will call methods on {@link CalendarInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calendarInterval(CalendarInterval)
         */
        default Builder calendarInterval(Consumer<CalendarInterval.Builder> calendarInterval) {
            return calendarInterval(CalendarInterval.builder().applyMutation(calendarInterval).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RollingInterval rollingInterval;

        private CalendarInterval calendarInterval;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Interval model) {
            rollingInterval(model.rollingInterval);
            calendarInterval(model.calendarInterval);
        }

        public final RollingInterval.Builder getRollingInterval() {
            return rollingInterval != null ? rollingInterval.toBuilder() : null;
        }

        public final void setRollingInterval(RollingInterval.BuilderImpl rollingInterval) {
            Object oldValue = this.rollingInterval;
            this.rollingInterval = rollingInterval != null ? rollingInterval.build() : null;
            handleUnionValueChange(Type.ROLLING_INTERVAL, oldValue, this.rollingInterval);
        }

        @Override
        public final Builder rollingInterval(RollingInterval rollingInterval) {
            Object oldValue = this.rollingInterval;
            this.rollingInterval = rollingInterval;
            handleUnionValueChange(Type.ROLLING_INTERVAL, oldValue, this.rollingInterval);
            return this;
        }

        public final CalendarInterval.Builder getCalendarInterval() {
            return calendarInterval != null ? calendarInterval.toBuilder() : null;
        }

        public final void setCalendarInterval(CalendarInterval.BuilderImpl calendarInterval) {
            Object oldValue = this.calendarInterval;
            this.calendarInterval = calendarInterval != null ? calendarInterval.build() : null;
            handleUnionValueChange(Type.CALENDAR_INTERVAL, oldValue, this.calendarInterval);
        }

        @Override
        public final Builder calendarInterval(CalendarInterval calendarInterval) {
            Object oldValue = this.calendarInterval;
            this.calendarInterval = calendarInterval;
            handleUnionValueChange(Type.CALENDAR_INTERVAL, oldValue, this.calendarInterval);
            return this;
        }

        @Override
        public Interval build() {
            return new Interval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Interval#type()
     */
    public enum Type {
        ROLLING_INTERVAL,

        CALENDAR_INTERVAL,

        UNKNOWN_TO_SDK_VERSION
    }
}
