/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationsignals.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceLevelObjectivesRequest extends ApplicationSignalsRequest implements
        ToCopyableBuilder<ListServiceLevelObjectivesRequest.Builder, ListServiceLevelObjectivesRequest> {
    private static final SdkField<Map<String, String>> KEY_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("KeyAttributes")
            .getter(getter(ListServiceLevelObjectivesRequest::keyAttributes))
            .setter(setter(Builder::keyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationName").getter(getter(ListServiceLevelObjectivesRequest::operationName))
            .setter(setter(Builder::operationName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("OperationName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListServiceLevelObjectivesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceLevelObjectivesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            OPERATION_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> keyAttributes;

    private final String operationName;

    private final Integer maxResults;

    private final String nextToken;

    private ListServiceLevelObjectivesRequest(BuilderImpl builder) {
        super(builder);
        this.keyAttributes = builder.keyAttributes;
        this.operationName = builder.operationName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasKeyAttributes() {
        return keyAttributes != null && !(keyAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * You can use this optional field to specify which services you want to retrieve SLO information for.
     * </p>
     * <p>
     * This is a string-to-string map. It can include the following fields.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Type</code> designates the type of object this is.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code> field
     * is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of the
     * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeyAttributes} method.
     * </p>
     * 
     * @return You can use this optional field to specify which services you want to retrieve SLO information for.</p>
     *         <p>
     *         This is a string-to-string map. It can include the following fields.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Type</code> designates the type of object this is.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of
     *         the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Name</code> specifies the name of the object. This is used only if the value of the
     *         <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value
     *         of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
     *         </p>
     *         </li>
     */
    public final Map<String, String> keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * The name of the operation that this SLO is associated with.
     * </p>
     * 
     * @return The name of the operation that this SLO is associated with.
     */
    public final String operationName() {
        return operationName;
    }

    /**
     * <p>
     * The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is used.
     * </p>
     * 
     * @return The maximum number of results to return in one operation. If you omit this parameter, the default of 50
     *         is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Include this value, if it was returned by the previous operation, to get the next set of service level
     * objectives.
     * </p>
     * 
     * @return Include this value, if it was returned by the previous operation, to get the next set of service level
     *         objectives.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasKeyAttributes() ? keyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(operationName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceLevelObjectivesRequest)) {
            return false;
        }
        ListServiceLevelObjectivesRequest other = (ListServiceLevelObjectivesRequest) obj;
        return hasKeyAttributes() == other.hasKeyAttributes() && Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(operationName(), other.operationName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceLevelObjectivesRequest")
                .add("KeyAttributes", hasKeyAttributes() ? keyAttributes() : null).add("OperationName", operationName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "OperationName":
            return Optional.ofNullable(clazz.cast(operationName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAttributes", KEY_ATTRIBUTES_FIELD);
        map.put("OperationName", OPERATION_NAME_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceLevelObjectivesRequest, T> g) {
        return obj -> g.apply((ListServiceLevelObjectivesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationSignalsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceLevelObjectivesRequest> {
        /**
         * <p>
         * You can use this optional field to specify which services you want to retrieve SLO information for.
         * </p>
         * <p>
         * This is a string-to-string map. It can include the following fields.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Type</code> designates the type of object this is.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ResourceType</code> specifies the type of the resource. This field is used only when the value of the
         * <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Name</code> specifies the name of the object. This is used only if the value of the <code>Type</code>
         * field is <code>Service</code>, <code>RemoteService</code>, or <code>AWS::Service</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Identifier</code> identifies the resource objects of this resource. This is used only if the value of
         * the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyAttributes
         *        You can use this optional field to specify which services you want to retrieve SLO information
         *        for.</p>
         *        <p>
         *        This is a string-to-string map. It can include the following fields.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Type</code> designates the type of object this is.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ResourceType</code> specifies the type of the resource. This field is used only when the value
         *        of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Name</code> specifies the name of the object. This is used only if the value of the
         *        <code>Type</code> field is <code>Service</code>, <code>RemoteService</code>, or
         *        <code>AWS::Service</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Identifier</code> identifies the resource objects of this resource. This is used only if the
         *        value of the <code>Type</code> field is <code>Resource</code> or <code>AWS::Resource</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Environment</code> specifies the location where this object is hosted, or what it belongs to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(Map<String, String> keyAttributes);

        /**
         * <p>
         * The name of the operation that this SLO is associated with.
         * </p>
         * 
         * @param operationName
         *        The name of the operation that this SLO is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationName(String operationName);

        /**
         * <p>
         * The maximum number of results to return in one operation. If you omit this parameter, the default of 50 is
         * used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in one operation. If you omit this parameter, the default of
         *        50 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Include this value, if it was returned by the previous operation, to get the next set of service level
         * objectives.
         * </p>
         * 
         * @param nextToken
         *        Include this value, if it was returned by the previous operation, to get the next set of service level
         *        objectives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationSignalsRequest.BuilderImpl implements Builder {
        private Map<String, String> keyAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String operationName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceLevelObjectivesRequest model) {
            super(model);
            keyAttributes(model.keyAttributes);
            operationName(model.operationName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getKeyAttributes() {
            if (keyAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return keyAttributes;
        }

        public final void setKeyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
        }

        @Override
        public final Builder keyAttributes(Map<String, String> keyAttributes) {
            this.keyAttributes = AttributesCopier.copy(keyAttributes);
            return this;
        }

        public final String getOperationName() {
            return operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceLevelObjectivesRequest build() {
            return new ListServiceLevelObjectivesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
